/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.AnalyzeTextTaskResult;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextTaskResultsKind;
import com.azure.ai.textanalytics.implementation.models.PiiResult;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class PiiTaskResult
extends AnalyzeTextTaskResult {
    private AnalyzeTextTaskResultsKind kind = AnalyzeTextTaskResultsKind.PII_ENTITY_RECOGNITION_RESULTS;
    private PiiResult results;

    @Override
    public AnalyzeTextTaskResultsKind getKind() {
        return this.kind;
    }

    public PiiResult getResults() {
        return this.results;
    }

    public PiiTaskResult setResults(PiiResult results) {
        this.results = results;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("results", (JsonSerializable)this.results);
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    public static PiiTaskResult fromJson(JsonReader jsonReader) throws IOException {
        return (PiiTaskResult)jsonReader.readObject(reader -> {
            PiiTaskResult deserializedPiiTaskResult = new PiiTaskResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("results".equals(fieldName)) {
                    deserializedPiiTaskResult.results = PiiResult.fromJson(reader);
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedPiiTaskResult.kind = AnalyzeTextTaskResultsKind.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPiiTaskResult;
        });
    }
}

