/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.ClassificationDocumentResult;
import com.azure.ai.textanalytics.implementation.models.ClassificationResult;
import com.azure.ai.textanalytics.implementation.models.DocumentStatistics;
import com.azure.ai.textanalytics.implementation.models.DocumentWarning;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class CustomLabelClassificationResultDocumentsItem
extends ClassificationDocumentResult {
    @Override
    public CustomLabelClassificationResultDocumentsItem setClassProperty(List<ClassificationResult> classProperty) {
        super.setClassProperty(classProperty);
        return this;
    }

    @Override
    public CustomLabelClassificationResultDocumentsItem setId(String id) {
        super.setId(id);
        return this;
    }

    @Override
    public CustomLabelClassificationResultDocumentsItem setWarnings(List<DocumentWarning> warnings) {
        super.setWarnings((List)warnings);
        return this;
    }

    @Override
    public CustomLabelClassificationResultDocumentsItem setStatistics(DocumentStatistics statistics) {
        super.setStatistics(statistics);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.getId());
        jsonWriter.writeArrayField("warnings", this.getWarnings(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("class", this.getClassProperty(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("statistics", (JsonSerializable)this.getStatistics());
        return jsonWriter.writeEndObject();
    }

    public static CustomLabelClassificationResultDocumentsItem fromJson(JsonReader jsonReader) throws IOException {
        return (CustomLabelClassificationResultDocumentsItem)jsonReader.readObject(reader -> {
            CustomLabelClassificationResultDocumentsItem deserializedCustomLabelClassificationResultDocumentsItem = new CustomLabelClassificationResultDocumentsItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedCustomLabelClassificationResultDocumentsItem.setId(reader.getString());
                    continue;
                }
                if ("warnings".equals(fieldName)) {
                    List warnings = reader.readArray(reader1 -> DocumentWarning.fromJson(reader1));
                    deserializedCustomLabelClassificationResultDocumentsItem.setWarnings(warnings);
                    continue;
                }
                if ("class".equals(fieldName)) {
                    List classProperty = reader.readArray(reader1 -> ClassificationResult.fromJson(reader1));
                    deserializedCustomLabelClassificationResultDocumentsItem.setClassProperty(classProperty);
                    continue;
                }
                if ("statistics".equals(fieldName)) {
                    deserializedCustomLabelClassificationResultDocumentsItem.setStatistics(DocumentStatistics.fromJson(reader));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomLabelClassificationResultDocumentsItem;
        });
    }
}

