/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.models;

import com.azure.ai.textanalytics.implementation.HealthcareEntityPropertiesHelper;
import com.azure.ai.textanalytics.models.EntityDataSource;
import com.azure.ai.textanalytics.models.HealthcareEntityAssertion;
import com.azure.ai.textanalytics.models.HealthcareEntityCategory;
import com.azure.core.util.IterableStream;

public final class HealthcareEntity {
    private String text;
    private String normalizedText;
    private HealthcareEntityCategory category;
    private String subcategory;
    private double confidenceScore;
    private int offset;
    private int length;
    private IterableStream<EntityDataSource> dataSources;
    private HealthcareEntityAssertion assertion;

    public String getText() {
        return this.text;
    }

    public String getNormalizedText() {
        return this.normalizedText;
    }

    public HealthcareEntityCategory getCategory() {
        return this.category;
    }

    public String getSubcategory() {
        return this.subcategory;
    }

    public double getConfidenceScore() {
        return this.confidenceScore;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public IterableStream<EntityDataSource> getDataSources() {
        return this.dataSources;
    }

    public HealthcareEntityAssertion getAssertion() {
        return this.assertion;
    }

    private void setText(String text) {
        this.text = text;
    }

    private void setNormalizedText(String normalizedText) {
        this.normalizedText = normalizedText;
    }

    private void setCategory(HealthcareEntityCategory category) {
        this.category = category;
    }

    private void setSubcategory(String subcategory) {
        this.subcategory = subcategory;
    }

    private void setConfidenceScore(double confidenceScore) {
        this.confidenceScore = confidenceScore;
    }

    private void setOffset(int offset) {
        this.offset = offset;
    }

    private void setLength(int length) {
        this.length = length;
    }

    private void setDataSources(IterableStream<EntityDataSource> dataSources) {
        this.dataSources = dataSources;
    }

    private void setAssertion(HealthcareEntityAssertion assertion) {
        this.assertion = assertion;
    }

    static {
        HealthcareEntityPropertiesHelper.setAccessor(new HealthcareEntityPropertiesHelper.HealthcareEntityAccessor(){

            @Override
            public void setText(HealthcareEntity healthcareEntity, String text) {
                healthcareEntity.setText(text);
            }

            @Override
            public void setNormalizedText(HealthcareEntity healthcareEntity, String normalizedText) {
                healthcareEntity.setNormalizedText(normalizedText);
            }

            @Override
            public void setCategory(HealthcareEntity healthcareEntity, HealthcareEntityCategory category) {
                healthcareEntity.setCategory(category);
            }

            @Override
            public void setSubcategory(HealthcareEntity healthcareEntity, String subcategory) {
                healthcareEntity.setSubcategory(subcategory);
            }

            @Override
            public void setConfidenceScore(HealthcareEntity healthcareEntity, double confidenceScore) {
                healthcareEntity.setConfidenceScore(confidenceScore);
            }

            @Override
            public void setOffset(HealthcareEntity healthcareEntity, int offset) {
                healthcareEntity.setOffset(offset);
            }

            @Override
            public void setLength(HealthcareEntity healthcareEntity, int length) {
                healthcareEntity.setLength(length);
            }

            @Override
            public void setDataSources(HealthcareEntity healthcareEntity, IterableStream<EntityDataSource> dataSources) {
                healthcareEntity.setDataSources((IterableStream<EntityDataSource>)dataSources);
            }

            @Override
            public void setAssertion(HealthcareEntity healthcareEntity, HealthcareEntityAssertion assertion) {
                healthcareEntity.setAssertion(assertion);
            }
        });
    }
}

