/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.DocumentSentimentValue;
import com.azure.ai.textanalytics.implementation.models.DocumentStatistics;
import com.azure.ai.textanalytics.implementation.models.DocumentWarning;
import com.azure.ai.textanalytics.implementation.models.SentenceSentiment;
import com.azure.ai.textanalytics.implementation.models.SentimentConfidenceScorePerLabel;
import com.azure.ai.textanalytics.implementation.models.SentimentDocumentResult;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class SentimentResponseDocumentsItem
extends SentimentDocumentResult {
    @Override
    public SentimentResponseDocumentsItem setSentiment(DocumentSentimentValue sentiment) {
        super.setSentiment(sentiment);
        return this;
    }

    @Override
    public SentimentResponseDocumentsItem setConfidenceScores(SentimentConfidenceScorePerLabel confidenceScores) {
        super.setConfidenceScores(confidenceScores);
        return this;
    }

    @Override
    public SentimentResponseDocumentsItem setSentences(List<SentenceSentiment> sentences) {
        super.setSentences(sentences);
        return this;
    }

    @Override
    public SentimentResponseDocumentsItem setId(String id) {
        super.setId(id);
        return this;
    }

    @Override
    public SentimentResponseDocumentsItem setWarnings(List<DocumentWarning> warnings) {
        super.setWarnings((List)warnings);
        return this;
    }

    @Override
    public SentimentResponseDocumentsItem setStatistics(DocumentStatistics statistics) {
        super.setStatistics(statistics);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.getId());
        jsonWriter.writeArrayField("warnings", this.getWarnings(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("sentiment", this.getSentiment() == null ? null : this.getSentiment().toString());
        jsonWriter.writeJsonField("confidenceScores", (JsonSerializable)this.getConfidenceScores());
        jsonWriter.writeArrayField("sentences", this.getSentences(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("statistics", (JsonSerializable)this.getStatistics());
        return jsonWriter.writeEndObject();
    }

    public static SentimentResponseDocumentsItem fromJson(JsonReader jsonReader) throws IOException {
        return (SentimentResponseDocumentsItem)jsonReader.readObject(reader -> {
            SentimentResponseDocumentsItem deserializedSentimentResponseDocumentsItem = new SentimentResponseDocumentsItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSentimentResponseDocumentsItem.setId(reader.getString());
                    continue;
                }
                if ("warnings".equals(fieldName)) {
                    List warnings = reader.readArray(reader1 -> DocumentWarning.fromJson(reader1));
                    deserializedSentimentResponseDocumentsItem.setWarnings(warnings);
                    continue;
                }
                if ("sentiment".equals(fieldName)) {
                    deserializedSentimentResponseDocumentsItem.setSentiment(DocumentSentimentValue.fromString(reader.getString()));
                    continue;
                }
                if ("confidenceScores".equals(fieldName)) {
                    deserializedSentimentResponseDocumentsItem.setConfidenceScores(SentimentConfidenceScorePerLabel.fromJson(reader));
                    continue;
                }
                if ("sentences".equals(fieldName)) {
                    List sentences = reader.readArray(reader1 -> SentenceSentiment.fromJson(reader1));
                    deserializedSentimentResponseDocumentsItem.setSentences(sentences);
                    continue;
                }
                if ("statistics".equals(fieldName)) {
                    deserializedSentimentResponseDocumentsItem.setStatistics(DocumentStatistics.fromJson(reader));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSentimentResponseDocumentsItem;
        });
    }
}

