/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.DocumentStatistics;
import com.azure.ai.textanalytics.implementation.models.DocumentWarning;
import com.azure.ai.textanalytics.implementation.models.KeyPhrasesDocumentResult;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class KeyPhraseResultDocumentsItem
extends KeyPhrasesDocumentResult {
    @Override
    public KeyPhraseResultDocumentsItem setKeyPhrases(List<String> keyPhrases) {
        super.setKeyPhrases(keyPhrases);
        return this;
    }

    @Override
    public KeyPhraseResultDocumentsItem setId(String id) {
        super.setId(id);
        return this;
    }

    @Override
    public KeyPhraseResultDocumentsItem setWarnings(List<DocumentWarning> warnings) {
        super.setWarnings((List)warnings);
        return this;
    }

    @Override
    public KeyPhraseResultDocumentsItem setStatistics(DocumentStatistics statistics) {
        super.setStatistics(statistics);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.getId());
        jsonWriter.writeArrayField("warnings", this.getWarnings(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("keyPhrases", this.getKeyPhrases(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("statistics", (JsonSerializable)this.getStatistics());
        return jsonWriter.writeEndObject();
    }

    public static KeyPhraseResultDocumentsItem fromJson(JsonReader jsonReader) throws IOException {
        return (KeyPhraseResultDocumentsItem)jsonReader.readObject(reader -> {
            KeyPhraseResultDocumentsItem deserializedKeyPhraseResultDocumentsItem = new KeyPhraseResultDocumentsItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedKeyPhraseResultDocumentsItem.setId(reader.getString());
                    continue;
                }
                if ("warnings".equals(fieldName)) {
                    List warnings = reader.readArray(reader1 -> DocumentWarning.fromJson(reader1));
                    deserializedKeyPhraseResultDocumentsItem.setWarnings(warnings);
                    continue;
                }
                if ("keyPhrases".equals(fieldName)) {
                    List keyPhrases = reader.readArray(reader1 -> reader1.getString());
                    deserializedKeyPhraseResultDocumentsItem.setKeyPhrases(keyPhrases);
                    continue;
                }
                if ("statistics".equals(fieldName)) {
                    deserializedKeyPhraseResultDocumentsItem.setStatistics(DocumentStatistics.fromJson(reader));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyPhraseResultDocumentsItem;
        });
    }
}

