/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.PreBuiltTaskParameters;
import com.azure.ai.textanalytics.implementation.models.StringIndexType;
import com.azure.ai.textanalytics.models.ExtractiveSummarySentencesOrder;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ExtractiveSummarizationTaskParameters
extends PreBuiltTaskParameters {
    private Integer sentenceCount;
    private ExtractiveSummarySentencesOrder sortBy;
    private StringIndexType stringIndexType;

    public Integer getSentenceCount() {
        return this.sentenceCount;
    }

    public ExtractiveSummarizationTaskParameters setSentenceCount(Integer sentenceCount) {
        this.sentenceCount = sentenceCount;
        return this;
    }

    public ExtractiveSummarySentencesOrder getSortBy() {
        return this.sortBy;
    }

    public ExtractiveSummarizationTaskParameters setSortBy(ExtractiveSummarySentencesOrder sortBy) {
        this.sortBy = sortBy;
        return this;
    }

    public StringIndexType getStringIndexType() {
        return this.stringIndexType;
    }

    public ExtractiveSummarizationTaskParameters setStringIndexType(StringIndexType stringIndexType) {
        this.stringIndexType = stringIndexType;
        return this;
    }

    @Override
    public ExtractiveSummarizationTaskParameters setModelVersion(String modelVersion) {
        super.setModelVersion(modelVersion);
        return this;
    }

    @Override
    public ExtractiveSummarizationTaskParameters setLoggingOptOut(Boolean loggingOptOut) {
        super.setLoggingOptOut(loggingOptOut);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("loggingOptOut", this.isLoggingOptOut());
        jsonWriter.writeStringField("modelVersion", this.getModelVersion());
        jsonWriter.writeNumberField("sentenceCount", (Number)this.sentenceCount);
        jsonWriter.writeStringField("sortBy", this.sortBy == null ? null : this.sortBy.toString());
        jsonWriter.writeStringField("stringIndexType", this.stringIndexType == null ? null : this.stringIndexType.toString());
        return jsonWriter.writeEndObject();
    }

    public static ExtractiveSummarizationTaskParameters fromJson(JsonReader jsonReader) throws IOException {
        return (ExtractiveSummarizationTaskParameters)jsonReader.readObject(reader -> {
            ExtractiveSummarizationTaskParameters deserializedExtractiveSummarizationTaskParameters = new ExtractiveSummarizationTaskParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("loggingOptOut".equals(fieldName)) {
                    deserializedExtractiveSummarizationTaskParameters.setLoggingOptOut((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("modelVersion".equals(fieldName)) {
                    deserializedExtractiveSummarizationTaskParameters.setModelVersion(reader.getString());
                    continue;
                }
                if ("sentenceCount".equals(fieldName)) {
                    deserializedExtractiveSummarizationTaskParameters.sentenceCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("sortBy".equals(fieldName)) {
                    deserializedExtractiveSummarizationTaskParameters.sortBy = ExtractiveSummarySentencesOrder.fromString(reader.getString());
                    continue;
                }
                if ("stringIndexType".equals(fieldName)) {
                    deserializedExtractiveSummarizationTaskParameters.stringIndexType = StringIndexType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExtractiveSummarizationTaskParameters;
        });
    }
}

