/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.DocumentStatistics;
import com.azure.ai.textanalytics.implementation.models.DocumentWarning;
import com.azure.ai.textanalytics.implementation.models.LinkedEntitiesDocumentResult;
import com.azure.ai.textanalytics.implementation.models.LinkedEntity;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class EntityLinkingResultDocumentsItem
extends LinkedEntitiesDocumentResult {
    @Override
    public EntityLinkingResultDocumentsItem setEntities(List<LinkedEntity> entities) {
        super.setEntities(entities);
        return this;
    }

    @Override
    public EntityLinkingResultDocumentsItem setId(String id) {
        super.setId(id);
        return this;
    }

    @Override
    public EntityLinkingResultDocumentsItem setWarnings(List<DocumentWarning> warnings) {
        super.setWarnings((List)warnings);
        return this;
    }

    @Override
    public EntityLinkingResultDocumentsItem setStatistics(DocumentStatistics statistics) {
        super.setStatistics(statistics);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.getId());
        jsonWriter.writeArrayField("warnings", this.getWarnings(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("entities", this.getEntities(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("statistics", (JsonSerializable)this.getStatistics());
        return jsonWriter.writeEndObject();
    }

    public static EntityLinkingResultDocumentsItem fromJson(JsonReader jsonReader) throws IOException {
        return (EntityLinkingResultDocumentsItem)jsonReader.readObject(reader -> {
            EntityLinkingResultDocumentsItem deserializedEntityLinkingResultDocumentsItem = new EntityLinkingResultDocumentsItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedEntityLinkingResultDocumentsItem.setId(reader.getString());
                    continue;
                }
                if ("warnings".equals(fieldName)) {
                    List warnings = reader.readArray(reader1 -> DocumentWarning.fromJson(reader1));
                    deserializedEntityLinkingResultDocumentsItem.setWarnings(warnings);
                    continue;
                }
                if ("entities".equals(fieldName)) {
                    List entities = reader.readArray(reader1 -> LinkedEntity.fromJson(reader1));
                    deserializedEntityLinkingResultDocumentsItem.setEntities(entities);
                    continue;
                }
                if ("statistics".equals(fieldName)) {
                    deserializedEntityLinkingResultDocumentsItem.setStatistics(DocumentStatistics.fromJson(reader));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEntityLinkingResultDocumentsItem;
        });
    }
}

