/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.DocumentStatistics;
import com.azure.ai.textanalytics.implementation.models.DocumentWarning;
import com.azure.ai.textanalytics.implementation.models.EntitiesDocumentResult;
import com.azure.ai.textanalytics.implementation.models.Entity;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class EntitiesResultDocumentsItem
extends EntitiesDocumentResult {
    @Override
    public EntitiesResultDocumentsItem setEntities(List<Entity> entities) {
        super.setEntities(entities);
        return this;
    }

    @Override
    public EntitiesResultDocumentsItem setId(String id) {
        super.setId(id);
        return this;
    }

    @Override
    public EntitiesResultDocumentsItem setWarnings(List<DocumentWarning> warnings) {
        super.setWarnings((List)warnings);
        return this;
    }

    @Override
    public EntitiesResultDocumentsItem setStatistics(DocumentStatistics statistics) {
        super.setStatistics(statistics);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.getId());
        jsonWriter.writeArrayField("warnings", this.getWarnings(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("entities", this.getEntities(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("statistics", (JsonSerializable)this.getStatistics());
        return jsonWriter.writeEndObject();
    }

    public static EntitiesResultDocumentsItem fromJson(JsonReader jsonReader) throws IOException {
        return (EntitiesResultDocumentsItem)jsonReader.readObject(reader -> {
            EntitiesResultDocumentsItem deserializedEntitiesResultDocumentsItem = new EntitiesResultDocumentsItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedEntitiesResultDocumentsItem.setId(reader.getString());
                    continue;
                }
                if ("warnings".equals(fieldName)) {
                    List warnings = reader.readArray(reader1 -> DocumentWarning.fromJson(reader1));
                    deserializedEntitiesResultDocumentsItem.setWarnings(warnings);
                    continue;
                }
                if ("entities".equals(fieldName)) {
                    List entities = reader.readArray(reader1 -> Entity.fromJson(reader1));
                    deserializedEntitiesResultDocumentsItem.setEntities(entities);
                    continue;
                }
                if ("statistics".equals(fieldName)) {
                    deserializedEntitiesResultDocumentsItem.setStatistics(DocumentStatistics.fromJson(reader));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEntitiesResultDocumentsItem;
        });
    }
}

