/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.DocumentStatistics;
import com.azure.ai.textanalytics.implementation.models.DocumentWarning;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public class DocumentResult
implements JsonSerializable<DocumentResult> {
    private String id;
    private List<DocumentWarning> warnings;
    private DocumentStatistics statistics;

    public String getId() {
        return this.id;
    }

    public DocumentResult setId(String id) {
        this.id = id;
        return this;
    }

    public List<DocumentWarning> getWarnings() {
        return this.warnings;
    }

    public DocumentResult setWarnings(List<DocumentWarning> warnings) {
        this.warnings = warnings;
        return this;
    }

    public DocumentStatistics getStatistics() {
        return this.statistics;
    }

    public DocumentResult setStatistics(DocumentStatistics statistics) {
        this.statistics = statistics;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeArrayField("warnings", this.warnings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("statistics", (JsonSerializable)this.statistics);
        return jsonWriter.writeEndObject();
    }

    public static DocumentResult fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentResult)jsonReader.readObject(reader -> {
            DocumentResult deserializedDocumentResult = new DocumentResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDocumentResult.id = reader.getString();
                    continue;
                }
                if ("warnings".equals(fieldName)) {
                    List warnings;
                    deserializedDocumentResult.warnings = warnings = reader.readArray(reader1 -> DocumentWarning.fromJson(reader1));
                    continue;
                }
                if ("statistics".equals(fieldName)) {
                    deserializedDocumentResult.statistics = DocumentStatistics.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDocumentResult;
        });
    }
}

