/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.DetectedLanguage;
import com.azure.ai.textanalytics.implementation.models.DocumentStatistics;
import com.azure.ai.textanalytics.implementation.models.DocumentWarning;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class DocumentLanguage
implements JsonSerializable<DocumentLanguage> {
    private String id;
    private DetectedLanguage detectedLanguage;
    private List<DocumentWarning> warnings;
    private DocumentStatistics statistics;

    public String getId() {
        return this.id;
    }

    public DocumentLanguage setId(String id) {
        this.id = id;
        return this;
    }

    public DetectedLanguage getDetectedLanguage() {
        return this.detectedLanguage;
    }

    public DocumentLanguage setDetectedLanguage(DetectedLanguage detectedLanguage) {
        this.detectedLanguage = detectedLanguage;
        return this;
    }

    public List<DocumentWarning> getWarnings() {
        return this.warnings;
    }

    public DocumentLanguage setWarnings(List<DocumentWarning> warnings) {
        this.warnings = warnings;
        return this;
    }

    public DocumentStatistics getStatistics() {
        return this.statistics;
    }

    public DocumentLanguage setStatistics(DocumentStatistics statistics) {
        this.statistics = statistics;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeJsonField("detectedLanguage", (JsonSerializable)this.detectedLanguage);
        jsonWriter.writeArrayField("warnings", this.warnings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("statistics", (JsonSerializable)this.statistics);
        return jsonWriter.writeEndObject();
    }

    public static DocumentLanguage fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentLanguage)jsonReader.readObject(reader -> {
            DocumentLanguage deserializedDocumentLanguage = new DocumentLanguage();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDocumentLanguage.id = reader.getString();
                    continue;
                }
                if ("confidenceScores".equals(fieldName)) {
                    deserializedDocumentLanguage.detectedLanguage = DetectedLanguage.fromJson(reader);
                    continue;
                }
                if ("warnings".equals(fieldName)) {
                    List warnings;
                    deserializedDocumentLanguage.warnings = warnings = reader.readArray(reader1 -> DocumentWarning.fromJson(reader1));
                    continue;
                }
                if ("statistics".equals(fieldName)) {
                    deserializedDocumentLanguage.statistics = DocumentStatistics.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDocumentLanguage;
        });
    }
}

