/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.ClassificationResult;
import com.azure.ai.textanalytics.implementation.models.DocumentResult;
import com.azure.ai.textanalytics.implementation.models.DocumentStatistics;
import com.azure.ai.textanalytics.implementation.models.DocumentWarning;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public class ClassificationDocumentResult
extends DocumentResult {
    private List<ClassificationResult> classProperty;

    public List<ClassificationResult> getClassProperty() {
        return this.classProperty;
    }

    public ClassificationDocumentResult setClassProperty(List<ClassificationResult> classProperty) {
        this.classProperty = classProperty;
        return this;
    }

    @Override
    public ClassificationDocumentResult setId(String id) {
        super.setId(id);
        return this;
    }

    @Override
    public ClassificationDocumentResult setWarnings(List<DocumentWarning> warnings) {
        super.setWarnings(warnings);
        return this;
    }

    @Override
    public ClassificationDocumentResult setStatistics(DocumentStatistics statistics) {
        super.setStatistics(statistics);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.getId());
        jsonWriter.writeArrayField("warnings", this.getWarnings(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("statistics", (JsonSerializable)this.getStatistics());
        jsonWriter.writeArrayField("class", this.classProperty, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ClassificationDocumentResult fromJson(JsonReader jsonReader) throws IOException {
        return (ClassificationDocumentResult)jsonReader.readObject(reader -> {
            ClassificationDocumentResult deserializedClassificationDocumentResult = new ClassificationDocumentResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedClassificationDocumentResult.setId(reader.getString());
                    continue;
                }
                if ("warnings".equals(fieldName)) {
                    List warnings = reader.readArray(reader1 -> DocumentWarning.fromJson(reader1));
                    deserializedClassificationDocumentResult.setWarnings(warnings);
                    continue;
                }
                if ("statistics".equals(fieldName)) {
                    deserializedClassificationDocumentResult.setStatistics(DocumentStatistics.fromJson(reader));
                    continue;
                }
                if ("class".equals(fieldName)) {
                    List classProperty;
                    deserializedClassificationDocumentResult.classProperty = classProperty = reader.readArray(reader1 -> ClassificationResult.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClassificationDocumentResult;
        });
    }
}

