/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.AnalyzeJobMetadata;
import com.azure.ai.textanalytics.implementation.models.RequestStatistics;
import com.azure.ai.textanalytics.implementation.models.TasksStateTasksOld;
import com.azure.ai.textanalytics.models.TextAnalyticsError;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class AnalyzeJobState
extends AnalyzeJobMetadata {
    private TasksStateTasksOld tasks;
    private List<TextAnalyticsError> errors;
    private RequestStatistics statistics;
    private String nextLink;

    public TasksStateTasksOld getTasks() {
        return this.tasks;
    }

    public AnalyzeJobState setTasks(TasksStateTasksOld tasks) {
        this.tasks = tasks;
        return this;
    }

    public List<TextAnalyticsError> getErrors() {
        return this.errors;
    }

    public AnalyzeJobState setErrors(List<TextAnalyticsError> errors) {
        this.errors = errors;
        return this;
    }

    public RequestStatistics getStatistics() {
        return this.statistics;
    }

    public AnalyzeJobState setStatistics(RequestStatistics statistics) {
        this.statistics = statistics;
        return this;
    }

    public String getNextLink() {
        return this.nextLink;
    }

    public AnalyzeJobState setNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("tasks", (JsonSerializable)this.tasks);
        jsonWriter.writeArrayField("errors", this.errors, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("statistics", (JsonSerializable)this.statistics);
        jsonWriter.writeStringField("@nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static AnalyzeJobState fromJson(JsonReader jsonReader) throws IOException {
        return (AnalyzeJobState)jsonReader.readObject(reader -> {
            AnalyzeJobState deserializedAnalyzeJobState = new AnalyzeJobState();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tasks".equals(fieldName)) {
                    deserializedAnalyzeJobState.tasks = TasksStateTasksOld.fromJson(reader);
                    continue;
                }
                if ("errors".equals(fieldName)) {
                    deserializedAnalyzeJobState.errors = reader.readArray(reader1 -> TextAnalyticsError.fromJson(reader1));
                    continue;
                }
                if ("statistics".equals(fieldName)) {
                    deserializedAnalyzeJobState.statistics = RequestStatistics.fromJson(reader);
                    continue;
                }
                if ("@nextLink".equals(fieldName)) {
                    deserializedAnalyzeJobState.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAnalyzeJobState;
        });
    }
}

