/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics;

import com.azure.ai.textanalytics.AbstractiveSummaryUtilClient;
import com.azure.ai.textanalytics.AnalyzeActionsUtilClient;
import com.azure.ai.textanalytics.AnalyzeHealthcareEntityUtilClient;
import com.azure.ai.textanalytics.AnalyzeSentimentUtilClient;
import com.azure.ai.textanalytics.DetectLanguageUtilClient;
import com.azure.ai.textanalytics.ExtractKeyPhraseUtilClient;
import com.azure.ai.textanalytics.ExtractiveSummaryUtilClient;
import com.azure.ai.textanalytics.LabelClassifyUtilClient;
import com.azure.ai.textanalytics.RecognizeCustomEntitiesUtilClient;
import com.azure.ai.textanalytics.RecognizeEntityUtilClient;
import com.azure.ai.textanalytics.RecognizeLinkedEntityUtilClient;
import com.azure.ai.textanalytics.RecognizePiiEntityUtilClient;
import com.azure.ai.textanalytics.TextAnalyticsClientBuilder;
import com.azure.ai.textanalytics.TextAnalyticsServiceVersion;
import com.azure.ai.textanalytics.implementation.MicrosoftCognitiveLanguageServiceTextAnalysisImpl;
import com.azure.ai.textanalytics.implementation.TextAnalyticsClientImpl;
import com.azure.ai.textanalytics.implementation.Utility;
import com.azure.ai.textanalytics.models.AbstractiveSummaryOperationDetail;
import com.azure.ai.textanalytics.models.AbstractiveSummaryOptions;
import com.azure.ai.textanalytics.models.AnalyzeActionsOperationDetail;
import com.azure.ai.textanalytics.models.AnalyzeActionsOptions;
import com.azure.ai.textanalytics.models.AnalyzeHealthcareEntitiesOperationDetail;
import com.azure.ai.textanalytics.models.AnalyzeHealthcareEntitiesOptions;
import com.azure.ai.textanalytics.models.AnalyzeSentimentOptions;
import com.azure.ai.textanalytics.models.AnalyzeSentimentResult;
import com.azure.ai.textanalytics.models.CategorizedEntityCollection;
import com.azure.ai.textanalytics.models.ClassifyDocumentOperationDetail;
import com.azure.ai.textanalytics.models.DetectLanguageInput;
import com.azure.ai.textanalytics.models.DetectLanguageResult;
import com.azure.ai.textanalytics.models.DetectedLanguage;
import com.azure.ai.textanalytics.models.DocumentSentiment;
import com.azure.ai.textanalytics.models.ExtractiveSummaryOperationDetail;
import com.azure.ai.textanalytics.models.ExtractiveSummaryOptions;
import com.azure.ai.textanalytics.models.KeyPhrasesCollection;
import com.azure.ai.textanalytics.models.LinkedEntityCollection;
import com.azure.ai.textanalytics.models.MultiLabelClassifyOptions;
import com.azure.ai.textanalytics.models.PiiEntityCollection;
import com.azure.ai.textanalytics.models.RecognizeCustomEntitiesOperationDetail;
import com.azure.ai.textanalytics.models.RecognizeCustomEntitiesOptions;
import com.azure.ai.textanalytics.models.RecognizePiiEntitiesOptions;
import com.azure.ai.textanalytics.models.SingleLabelClassifyOptions;
import com.azure.ai.textanalytics.models.TextAnalyticsActions;
import com.azure.ai.textanalytics.models.TextAnalyticsRequestOptions;
import com.azure.ai.textanalytics.models.TextDocumentInput;
import com.azure.ai.textanalytics.util.AbstractiveSummaryPagedFlux;
import com.azure.ai.textanalytics.util.AnalyzeActionsResultPagedFlux;
import com.azure.ai.textanalytics.util.AnalyzeHealthcareEntitiesPagedFlux;
import com.azure.ai.textanalytics.util.AnalyzeSentimentResultCollection;
import com.azure.ai.textanalytics.util.ClassifyDocumentPagedFlux;
import com.azure.ai.textanalytics.util.DetectLanguageResultCollection;
import com.azure.ai.textanalytics.util.ExtractKeyPhrasesResultCollection;
import com.azure.ai.textanalytics.util.ExtractiveSummaryPagedFlux;
import com.azure.ai.textanalytics.util.RecognizeCustomEntitiesPagedFlux;
import com.azure.ai.textanalytics.util.RecognizeEntitiesResultCollection;
import com.azure.ai.textanalytics.util.RecognizeLinkedEntitiesResultCollection;
import com.azure.ai.textanalytics.util.RecognizePiiEntitiesResultCollection;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import reactor.core.publisher.Mono;

@ServiceClient(builder=TextAnalyticsClientBuilder.class, isAsync=true)
public final class TextAnalyticsAsyncClient {
    private final ClientLogger logger = new ClientLogger(TextAnalyticsAsyncClient.class);
    private final TextAnalyticsClientImpl legacyService;
    private final MicrosoftCognitiveLanguageServiceTextAnalysisImpl service;
    private final TextAnalyticsServiceVersion serviceVersion;
    private final String defaultCountryHint;
    private final String defaultLanguage;
    final DetectLanguageUtilClient detectLanguageUtilClient;
    final AnalyzeSentimentUtilClient analyzeSentimentUtilClient;
    final ExtractKeyPhraseUtilClient extractKeyPhraseUtilClient;
    final RecognizeEntityUtilClient recognizeEntityUtilClient;
    final RecognizePiiEntityUtilClient recognizePiiEntityUtilClient;
    final RecognizeLinkedEntityUtilClient recognizeLinkedEntityUtilClient;
    final RecognizeCustomEntitiesUtilClient recognizeCustomEntitiesUtilClient;
    final LabelClassifyUtilClient labelClassifyUtilClient;
    final AnalyzeHealthcareEntityUtilClient analyzeHealthcareEntityUtilClient;
    final AnalyzeActionsUtilClient analyzeActionsUtilClient;
    final AbstractiveSummaryUtilClient abstractiveSummaryUtilClient;
    final ExtractiveSummaryUtilClient extractiveSummaryUtilClient;

    TextAnalyticsAsyncClient(TextAnalyticsClientImpl legacyService, TextAnalyticsServiceVersion serviceVersion, String defaultCountryHint, String defaultLanguage) {
        this.legacyService = legacyService;
        this.service = null;
        this.serviceVersion = serviceVersion;
        this.defaultCountryHint = defaultCountryHint;
        this.defaultLanguage = defaultLanguage;
        this.detectLanguageUtilClient = new DetectLanguageUtilClient(legacyService, serviceVersion);
        this.analyzeSentimentUtilClient = new AnalyzeSentimentUtilClient(legacyService, serviceVersion);
        this.extractKeyPhraseUtilClient = new ExtractKeyPhraseUtilClient(legacyService, serviceVersion);
        this.recognizeEntityUtilClient = new RecognizeEntityUtilClient(legacyService, serviceVersion);
        this.recognizePiiEntityUtilClient = new RecognizePiiEntityUtilClient(legacyService, serviceVersion);
        this.recognizeLinkedEntityUtilClient = new RecognizeLinkedEntityUtilClient(legacyService, serviceVersion);
        this.recognizeCustomEntitiesUtilClient = new RecognizeCustomEntitiesUtilClient(null, serviceVersion);
        this.analyzeHealthcareEntityUtilClient = new AnalyzeHealthcareEntityUtilClient(legacyService, serviceVersion);
        this.analyzeActionsUtilClient = new AnalyzeActionsUtilClient(legacyService, serviceVersion);
        this.labelClassifyUtilClient = new LabelClassifyUtilClient(null, serviceVersion);
        this.abstractiveSummaryUtilClient = new AbstractiveSummaryUtilClient(null, serviceVersion);
        this.extractiveSummaryUtilClient = new ExtractiveSummaryUtilClient(null, serviceVersion);
    }

    TextAnalyticsAsyncClient(MicrosoftCognitiveLanguageServiceTextAnalysisImpl service, TextAnalyticsServiceVersion serviceVersion, String defaultCountryHint, String defaultLanguage) {
        this.legacyService = null;
        this.service = service;
        this.serviceVersion = serviceVersion;
        this.defaultCountryHint = defaultCountryHint;
        this.defaultLanguage = defaultLanguage;
        this.detectLanguageUtilClient = new DetectLanguageUtilClient(service, serviceVersion);
        this.analyzeSentimentUtilClient = new AnalyzeSentimentUtilClient(service, serviceVersion);
        this.extractKeyPhraseUtilClient = new ExtractKeyPhraseUtilClient(service, serviceVersion);
        this.recognizeEntityUtilClient = new RecognizeEntityUtilClient(service, serviceVersion);
        this.recognizePiiEntityUtilClient = new RecognizePiiEntityUtilClient(service, serviceVersion);
        this.recognizeLinkedEntityUtilClient = new RecognizeLinkedEntityUtilClient(service, serviceVersion);
        this.recognizeCustomEntitiesUtilClient = new RecognizeCustomEntitiesUtilClient(service.getAnalyzeTexts(), serviceVersion);
        this.analyzeHealthcareEntityUtilClient = new AnalyzeHealthcareEntityUtilClient(service.getAnalyzeTexts(), serviceVersion);
        this.analyzeActionsUtilClient = new AnalyzeActionsUtilClient(service.getAnalyzeTexts(), serviceVersion);
        this.labelClassifyUtilClient = new LabelClassifyUtilClient(service.getAnalyzeTexts(), serviceVersion);
        this.abstractiveSummaryUtilClient = new AbstractiveSummaryUtilClient(service.getAnalyzeTexts(), serviceVersion);
        this.extractiveSummaryUtilClient = new ExtractiveSummaryUtilClient(service.getAnalyzeTexts(), serviceVersion);
    }

    public String getDefaultCountryHint() {
        return this.defaultCountryHint;
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DetectedLanguage> detectLanguage(String document) {
        return this.detectLanguage(document, this.defaultCountryHint);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DetectedLanguage> detectLanguage(String document, String countryHint) {
        try {
            Objects.requireNonNull(document, "'document' cannot be null.");
            return this.detectLanguageBatch(Collections.singletonList(document), countryHint, null).map(detectLanguageResultCollection -> {
                DetectedLanguage detectedLanguage = null;
                Iterator i$ = detectLanguageResultCollection.iterator();
                while (i$.hasNext()) {
                    DetectLanguageResult detectLanguageResult = (DetectLanguageResult)i$.next();
                    if (detectLanguageResult.isError()) {
                        throw this.logger.logExceptionAsError((RuntimeException)((Object)Utility.toTextAnalyticsException(detectLanguageResult.getError())));
                    }
                    detectedLanguage = detectLanguageResult.getPrimaryLanguage();
                }
                return detectedLanguage;
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DetectLanguageResultCollection> detectLanguageBatch(Iterable<String> documents, String countryHint, TextAnalyticsRequestOptions options) {
        if (countryHint != null && "none".equalsIgnoreCase(countryHint)) {
            countryHint = "";
        }
        String finalCountryHint = countryHint;
        try {
            return this.detectLanguageBatchWithResponse(Utility.mapByIndex(documents, (index, value) -> new DetectLanguageInput((String)index, (String)value, finalCountryHint)), options).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DetectLanguageResultCollection>> detectLanguageBatchWithResponse(Iterable<DetectLanguageInput> documents, TextAnalyticsRequestOptions options) {
        return this.detectLanguageUtilClient.detectLanguageBatch(documents, options);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CategorizedEntityCollection> recognizeEntities(String document) {
        return this.recognizeEntities(document, this.defaultLanguage);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CategorizedEntityCollection> recognizeEntities(String document, String language) {
        return this.recognizeEntityUtilClient.recognizeEntities(document, language);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RecognizeEntitiesResultCollection> recognizeEntitiesBatch(Iterable<String> documents, String language, TextAnalyticsRequestOptions options) {
        try {
            return this.recognizeEntitiesBatchWithResponse(Utility.mapByIndex(documents, (index, value) -> {
                TextDocumentInput textDocumentInput = new TextDocumentInput((String)index, (String)value);
                textDocumentInput.setLanguage(language);
                return textDocumentInput;
            }), options).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RecognizeEntitiesResultCollection>> recognizeEntitiesBatchWithResponse(Iterable<TextDocumentInput> documents, TextAnalyticsRequestOptions options) {
        return this.recognizeEntityUtilClient.recognizeEntitiesBatch(documents, options);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PiiEntityCollection> recognizePiiEntities(String document) {
        return this.recognizePiiEntities(document, this.defaultLanguage);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PiiEntityCollection> recognizePiiEntities(String document, String language) {
        return this.recognizePiiEntityUtilClient.recognizePiiEntities(document, language, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PiiEntityCollection> recognizePiiEntities(String document, String language, RecognizePiiEntitiesOptions options) {
        return this.recognizePiiEntityUtilClient.recognizePiiEntities(document, language, options);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RecognizePiiEntitiesResultCollection> recognizePiiEntitiesBatch(Iterable<String> documents, String language, RecognizePiiEntitiesOptions options) {
        try {
            Utility.inputDocumentsValidation(documents);
            return this.recognizePiiEntitiesBatchWithResponse(Utility.mapByIndex(documents, (index, value) -> {
                TextDocumentInput textDocumentInput = new TextDocumentInput((String)index, (String)value);
                textDocumentInput.setLanguage(language);
                return textDocumentInput;
            }), options).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RecognizePiiEntitiesResultCollection>> recognizePiiEntitiesBatchWithResponse(Iterable<TextDocumentInput> documents, RecognizePiiEntitiesOptions options) {
        return this.recognizePiiEntityUtilClient.recognizePiiEntitiesBatch(documents, options);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LinkedEntityCollection> recognizeLinkedEntities(String document) {
        return this.recognizeLinkedEntities(document, this.defaultLanguage);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LinkedEntityCollection> recognizeLinkedEntities(String document, String language) {
        return this.recognizeLinkedEntityUtilClient.recognizeLinkedEntities(document, language);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RecognizeLinkedEntitiesResultCollection> recognizeLinkedEntitiesBatch(Iterable<String> documents, String language, TextAnalyticsRequestOptions options) {
        try {
            return this.recognizeLinkedEntitiesBatchWithResponse(Utility.mapByIndex(documents, (index, value) -> {
                TextDocumentInput textDocumentInput = new TextDocumentInput((String)index, (String)value);
                textDocumentInput.setLanguage(language);
                return textDocumentInput;
            }), options).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RecognizeLinkedEntitiesResultCollection>> recognizeLinkedEntitiesBatchWithResponse(Iterable<TextDocumentInput> documents, TextAnalyticsRequestOptions options) {
        return this.recognizeLinkedEntityUtilClient.recognizeLinkedEntitiesBatch(documents, options);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyPhrasesCollection> extractKeyPhrases(String document) {
        return this.extractKeyPhrases(document, this.defaultLanguage);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyPhrasesCollection> extractKeyPhrases(String document, String language) {
        return this.extractKeyPhraseUtilClient.extractKeyPhrasesSingleText(document, language);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ExtractKeyPhrasesResultCollection> extractKeyPhrasesBatch(Iterable<String> documents, String language, TextAnalyticsRequestOptions options) {
        try {
            return this.extractKeyPhrasesBatchWithResponse(Utility.mapByIndex(documents, (index, value) -> {
                TextDocumentInput textDocumentInput = new TextDocumentInput((String)index, (String)value);
                textDocumentInput.setLanguage(language);
                return textDocumentInput;
            }), options).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ExtractKeyPhrasesResultCollection>> extractKeyPhrasesBatchWithResponse(Iterable<TextDocumentInput> documents, TextAnalyticsRequestOptions options) {
        return this.extractKeyPhraseUtilClient.extractKeyPhrasesWithResponse(documents, options);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DocumentSentiment> analyzeSentiment(String document) {
        return this.analyzeSentiment(document, this.defaultLanguage);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DocumentSentiment> analyzeSentiment(String document, String language) {
        return this.analyzeSentiment(document, language, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DocumentSentiment> analyzeSentiment(String document, String language, AnalyzeSentimentOptions options) {
        try {
            Objects.requireNonNull(document, "'document' cannot be null.");
            return this.analyzeSentimentBatch(Collections.singletonList(document), language, options).map(sentimentResultCollection -> {
                DocumentSentiment documentSentiment = null;
                Iterator i$ = sentimentResultCollection.iterator();
                while (i$.hasNext()) {
                    AnalyzeSentimentResult sentimentResult = (AnalyzeSentimentResult)i$.next();
                    if (sentimentResult.isError()) {
                        throw this.logger.logExceptionAsError((RuntimeException)((Object)Utility.toTextAnalyticsException(sentimentResult.getError())));
                    }
                    documentSentiment = sentimentResult.getDocumentSentiment();
                }
                return documentSentiment;
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeSentimentResultCollection> analyzeSentimentBatch(Iterable<String> documents, String language, TextAnalyticsRequestOptions options) {
        return this.analyzeSentimentBatch(documents, language, new AnalyzeSentimentOptions().setIncludeStatistics(options == null ? false : options.isIncludeStatistics()).setModelVersion(options == null ? null : options.getModelVersion()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeSentimentResultCollection> analyzeSentimentBatch(Iterable<String> documents, String language, AnalyzeSentimentOptions options) {
        try {
            return this.analyzeSentimentBatchWithResponse(Utility.mapByIndex(documents, (index, value) -> {
                TextDocumentInput textDocumentInput = new TextDocumentInput((String)index, (String)value);
                textDocumentInput.setLanguage(language);
                return textDocumentInput;
            }), options).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnalyzeSentimentResultCollection>> analyzeSentimentBatchWithResponse(Iterable<TextDocumentInput> documents, TextAnalyticsRequestOptions options) {
        return this.analyzeSentimentUtilClient.analyzeSentimentBatch(documents, new AnalyzeSentimentOptions().setIncludeStatistics(options == null ? false : options.isIncludeStatistics()).setModelVersion(options == null ? null : options.getModelVersion()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnalyzeSentimentResultCollection>> analyzeSentimentBatchWithResponse(Iterable<TextDocumentInput> documents, AnalyzeSentimentOptions options) {
        return this.analyzeSentimentUtilClient.analyzeSentimentBatch(documents, options);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PollerFlux<AnalyzeHealthcareEntitiesOperationDetail, AnalyzeHealthcareEntitiesPagedFlux> beginAnalyzeHealthcareEntities(Iterable<String> documents) {
        return this.beginAnalyzeHealthcareEntities(documents, this.defaultLanguage, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PollerFlux<AnalyzeHealthcareEntitiesOperationDetail, AnalyzeHealthcareEntitiesPagedFlux> beginAnalyzeHealthcareEntities(Iterable<String> documents, String language, AnalyzeHealthcareEntitiesOptions options) {
        return this.beginAnalyzeHealthcareEntities(Utility.mapByIndex(documents, (index, value) -> {
            TextDocumentInput textDocumentInput = new TextDocumentInput((String)index, (String)value);
            textDocumentInput.setLanguage(language);
            return textDocumentInput;
        }), options);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PollerFlux<AnalyzeHealthcareEntitiesOperationDetail, AnalyzeHealthcareEntitiesPagedFlux> beginAnalyzeHealthcareEntities(Iterable<TextDocumentInput> documents, AnalyzeHealthcareEntitiesOptions options) {
        return this.analyzeHealthcareEntityUtilClient.beginAnalyzeHealthcareEntities(documents, options, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PollerFlux<RecognizeCustomEntitiesOperationDetail, RecognizeCustomEntitiesPagedFlux> beginRecognizeCustomEntities(Iterable<String> documents, String projectName, String deploymentName) {
        return this.beginRecognizeCustomEntities(documents, projectName, deploymentName, this.defaultLanguage, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PollerFlux<RecognizeCustomEntitiesOperationDetail, RecognizeCustomEntitiesPagedFlux> beginRecognizeCustomEntities(Iterable<String> documents, String projectName, String deploymentName, String language, RecognizeCustomEntitiesOptions options) {
        return this.beginRecognizeCustomEntities(Utility.mapByIndex(documents, (index, value) -> {
            TextDocumentInput textDocumentInput = new TextDocumentInput((String)index, (String)value);
            textDocumentInput.setLanguage(language);
            return textDocumentInput;
        }), projectName, deploymentName, options);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PollerFlux<RecognizeCustomEntitiesOperationDetail, RecognizeCustomEntitiesPagedFlux> beginRecognizeCustomEntities(Iterable<TextDocumentInput> documents, String projectName, String deploymentName, RecognizeCustomEntitiesOptions options) {
        return this.recognizeCustomEntitiesUtilClient.recognizeCustomEntities(documents, projectName, deploymentName, options, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PollerFlux<ClassifyDocumentOperationDetail, ClassifyDocumentPagedFlux> beginSingleLabelClassify(Iterable<String> documents, String projectName, String deploymentName) {
        return this.beginSingleLabelClassify(documents, projectName, deploymentName, this.defaultLanguage, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PollerFlux<ClassifyDocumentOperationDetail, ClassifyDocumentPagedFlux> beginSingleLabelClassify(Iterable<String> documents, String projectName, String deploymentName, String language, SingleLabelClassifyOptions options) {
        return this.beginSingleLabelClassify(Utility.mapByIndex(documents, (index, value) -> {
            TextDocumentInput textDocumentInput = new TextDocumentInput((String)index, (String)value);
            textDocumentInput.setLanguage(language);
            return textDocumentInput;
        }), projectName, deploymentName, options);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PollerFlux<ClassifyDocumentOperationDetail, ClassifyDocumentPagedFlux> beginSingleLabelClassify(Iterable<TextDocumentInput> documents, String projectName, String deploymentName, SingleLabelClassifyOptions options) {
        return this.labelClassifyUtilClient.singleLabelClassify(documents, projectName, deploymentName, options, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PollerFlux<ClassifyDocumentOperationDetail, ClassifyDocumentPagedFlux> beginMultiLabelClassify(Iterable<String> documents, String projectName, String deploymentName) {
        return this.beginMultiLabelClassify(documents, projectName, deploymentName, this.defaultLanguage, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PollerFlux<ClassifyDocumentOperationDetail, ClassifyDocumentPagedFlux> beginMultiLabelClassify(Iterable<String> documents, String projectName, String deploymentName, String language, MultiLabelClassifyOptions options) {
        return this.beginMultiLabelClassify(Utility.mapByIndex(documents, (index, value) -> {
            TextDocumentInput textDocumentInput = new TextDocumentInput((String)index, (String)value);
            textDocumentInput.setLanguage(language);
            return textDocumentInput;
        }), projectName, deploymentName, options);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PollerFlux<ClassifyDocumentOperationDetail, ClassifyDocumentPagedFlux> beginMultiLabelClassify(Iterable<TextDocumentInput> documents, String projectName, String deploymentName, MultiLabelClassifyOptions options) {
        return this.labelClassifyUtilClient.multiLabelClassify(documents, projectName, deploymentName, options, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PollerFlux<AbstractiveSummaryOperationDetail, AbstractiveSummaryPagedFlux> beginAbstractSummary(Iterable<String> documents) {
        return this.beginAbstractSummary(documents, this.defaultLanguage, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PollerFlux<AbstractiveSummaryOperationDetail, AbstractiveSummaryPagedFlux> beginAbstractSummary(Iterable<String> documents, String language, AbstractiveSummaryOptions options) {
        return this.beginAbstractSummary(Utility.mapByIndex(documents, (index, value) -> {
            TextDocumentInput textDocumentInput = new TextDocumentInput((String)index, (String)value);
            textDocumentInput.setLanguage(language);
            return textDocumentInput;
        }), options);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PollerFlux<AbstractiveSummaryOperationDetail, AbstractiveSummaryPagedFlux> beginAbstractSummary(Iterable<TextDocumentInput> documents, AbstractiveSummaryOptions options) {
        return this.abstractiveSummaryUtilClient.abstractiveSummaryAsync(documents, options, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PollerFlux<ExtractiveSummaryOperationDetail, ExtractiveSummaryPagedFlux> beginExtractSummary(Iterable<String> documents) {
        return this.beginExtractSummary(documents, this.defaultLanguage, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PollerFlux<ExtractiveSummaryOperationDetail, ExtractiveSummaryPagedFlux> beginExtractSummary(Iterable<String> documents, String language, ExtractiveSummaryOptions options) {
        return this.beginExtractSummary(Utility.mapByIndex(documents, (index, value) -> {
            TextDocumentInput textDocumentInput = new TextDocumentInput((String)index, (String)value);
            textDocumentInput.setLanguage(language);
            return textDocumentInput;
        }), options);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PollerFlux<ExtractiveSummaryOperationDetail, ExtractiveSummaryPagedFlux> beginExtractSummary(Iterable<TextDocumentInput> documents, ExtractiveSummaryOptions options) {
        return this.extractiveSummaryUtilClient.extractiveSummaryAsync(documents, options, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PollerFlux<AnalyzeActionsOperationDetail, AnalyzeActionsResultPagedFlux> beginAnalyzeActions(Iterable<String> documents, TextAnalyticsActions actions) {
        return this.beginAnalyzeActions(documents, actions, this.defaultLanguage, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PollerFlux<AnalyzeActionsOperationDetail, AnalyzeActionsResultPagedFlux> beginAnalyzeActions(Iterable<String> documents, TextAnalyticsActions actions, String language, AnalyzeActionsOptions options) {
        return this.beginAnalyzeActions(Utility.mapByIndex(documents, (index, value) -> {
            TextDocumentInput textDocumentInput = new TextDocumentInput((String)index, (String)value);
            textDocumentInput.setLanguage(language);
            return textDocumentInput;
        }), actions, options);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PollerFlux<AnalyzeActionsOperationDetail, AnalyzeActionsResultPagedFlux> beginAnalyzeActions(Iterable<TextDocumentInput> documents, TextAnalyticsActions actions, AnalyzeActionsOptions options) {
        return this.analyzeActionsUtilClient.beginAnalyzeActions(documents, actions, options, Context.NONE);
    }
}

