/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.models;

import com.azure.ai.textanalytics.models.TextAnalyticsError;
import com.azure.ai.textanalytics.models.TextAnalyticsException;
import com.azure.ai.textanalytics.models.TextDocumentStatistics;
import com.azure.core.util.logging.ClientLogger;
import java.util.Locale;

public class TextAnalyticsResult {
    private final ClientLogger logger = new ClientLogger(TextAnalyticsResult.class);
    private final String id;
    private final TextDocumentStatistics textDocumentStatistics;
    private final TextAnalyticsError error;
    private final boolean isError;

    TextAnalyticsResult(String id, TextDocumentStatistics textDocumentStatistics, TextAnalyticsError error) {
        this.id = id;
        this.error = error;
        this.isError = error != null;
        this.textDocumentStatistics = textDocumentStatistics;
    }

    public String getId() {
        return this.id;
    }

    public TextDocumentStatistics getStatistics() {
        this.throwExceptionIfError();
        return this.textDocumentStatistics;
    }

    public TextAnalyticsError getError() {
        return this.error;
    }

    public boolean isError() {
        return this.isError;
    }

    void throwExceptionIfError() {
        if (this.isError()) {
            throw this.logger.logExceptionAsError((RuntimeException)((Object)new TextAnalyticsException(String.format(Locale.ROOT, "Error in accessing the property on document id: %s, when %s returned with an error: %s", this.id, this.getClass().getSimpleName(), this.error.getMessage()), this.error.getErrorCode(), null)));
        }
    }
}

