/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.models;

import com.azure.ai.textanalytics.implementation.SentenceSentimentPropertiesHelper;
import com.azure.ai.textanalytics.models.SentenceOpinion;
import com.azure.ai.textanalytics.models.SentimentConfidenceScores;
import com.azure.ai.textanalytics.models.TextSentiment;
import com.azure.core.util.IterableStream;

public final class SentenceSentiment {
    private final String text;
    private final TextSentiment sentiment;
    private final SentimentConfidenceScores confidenceScores;
    private IterableStream<SentenceOpinion> opinions;
    private int offset;
    private int length;

    public SentenceSentiment(String text, TextSentiment sentiment, SentimentConfidenceScores confidenceScores) {
        this.text = text;
        this.sentiment = sentiment;
        this.confidenceScores = confidenceScores;
    }

    public String getText() {
        return this.text;
    }

    public TextSentiment getSentiment() {
        return this.sentiment;
    }

    public SentimentConfidenceScores getConfidenceScores() {
        return this.confidenceScores;
    }

    public IterableStream<SentenceOpinion> getOpinions() {
        return this.opinions;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    private void setOpinions(IterableStream<SentenceOpinion> opinions) {
        this.opinions = opinions;
    }

    private void setOffset(int offset) {
        this.offset = offset;
    }

    private void setLength(int length) {
        this.length = length;
    }

    static {
        SentenceSentimentPropertiesHelper.setAccessor(new SentenceSentimentPropertiesHelper.SentenceSentimentAccessor(){

            @Override
            public void setOpinions(SentenceSentiment sentenceSentiment, IterableStream<SentenceOpinion> opinions) {
                sentenceSentiment.setOpinions((IterableStream<SentenceOpinion>)opinions);
            }

            @Override
            public void setOffset(SentenceSentiment sentenceSentiment, int offset) {
                sentenceSentiment.setOffset(offset);
            }

            @Override
            public void setLength(SentenceSentiment sentenceSentiment, int length) {
                sentenceSentiment.setLength(length);
            }
        });
    }
}

