/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.ClassificationResult;
import com.azure.ai.textanalytics.implementation.models.DocumentStatistics;
import com.azure.ai.textanalytics.implementation.models.DocumentWarning;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class MultiClassificationDocument
implements JsonSerializable<MultiClassificationDocument> {
    private String id;
    private List<ClassificationResult> classifications;
    private List<DocumentWarning> warnings;
    private DocumentStatistics statistics;

    public String getId() {
        return this.id;
    }

    public MultiClassificationDocument setId(String id) {
        this.id = id;
        return this;
    }

    public List<ClassificationResult> getClassifications() {
        return this.classifications;
    }

    public MultiClassificationDocument setClassifications(List<ClassificationResult> classifications) {
        this.classifications = classifications;
        return this;
    }

    public List<DocumentWarning> getWarnings() {
        return this.warnings;
    }

    public MultiClassificationDocument setWarnings(List<DocumentWarning> warnings) {
        this.warnings = warnings;
        return this;
    }

    public DocumentStatistics getStatistics() {
        return this.statistics;
    }

    public MultiClassificationDocument setStatistics(DocumentStatistics statistics) {
        this.statistics = statistics;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeArrayField("classifications", this.classifications, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("warnings", this.warnings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("statistics", (JsonSerializable)this.statistics);
        return jsonWriter.writeEndObject();
    }

    public static MultiClassificationDocument fromJson(JsonReader jsonReader) throws IOException {
        return (MultiClassificationDocument)jsonReader.readObject(reader -> {
            MultiClassificationDocument deserializedMultiClassificationDocument = new MultiClassificationDocument();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMultiClassificationDocument.id = reader.getString();
                    continue;
                }
                if ("classification".equals(fieldName)) {
                    deserializedMultiClassificationDocument.classifications = reader.readArray(reader1 -> ClassificationResult.fromJson(reader1));
                    continue;
                }
                if ("warnings".equals(fieldName)) {
                    deserializedMultiClassificationDocument.warnings = reader.readArray(reader1 -> DocumentWarning.fromJson(reader1));
                    continue;
                }
                if ("statistics".equals(fieldName)) {
                    deserializedMultiClassificationDocument.statistics = DocumentStatistics.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMultiClassificationDocument;
        });
    }
}

