/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.Error;
import com.azure.ai.textanalytics.implementation.models.HealthcareResult;
import com.azure.ai.textanalytics.implementation.models.JobMetadata;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class HealthcareJobState
extends JobMetadata {
    private HealthcareResult results;
    private List<Error> errors;
    private String nextLink;

    public HealthcareResult getResults() {
        return this.results;
    }

    public HealthcareJobState setResults(HealthcareResult results) {
        this.results = results;
        return this;
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    public HealthcareJobState setErrors(List<Error> errors) {
        this.errors = errors;
        return this;
    }

    public String getNextLink() {
        return this.nextLink;
    }

    public HealthcareJobState setNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("results", (JsonSerializable)this.results);
        jsonWriter.writeArrayField("errors", this.errors, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("@nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static HealthcareJobState fromJson(JsonReader jsonReader) throws IOException {
        return (HealthcareJobState)jsonReader.readObject(reader -> {
            HealthcareJobState deserializedHealthcareJobState = new HealthcareJobState();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("results".equals(fieldName)) {
                    deserializedHealthcareJobState.results = HealthcareResult.fromJson(reader);
                    continue;
                }
                if ("errors".equals(fieldName)) {
                    deserializedHealthcareJobState.errors = reader.readArray(reader1 -> Error.fromJson(reader1));
                    continue;
                }
                if ("@nextLink".equals(fieldName)) {
                    deserializedHealthcareJobState.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHealthcareJobState;
        });
    }
}

