/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.DocumentResult;
import com.azure.ai.textanalytics.implementation.models.DocumentStatistics;
import com.azure.ai.textanalytics.implementation.models.DocumentWarning;
import com.azure.ai.textanalytics.implementation.models.Entity;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public class EntitiesDocumentResult
extends DocumentResult {
    private List<Entity> entities;

    public List<Entity> getEntities() {
        return this.entities;
    }

    public EntitiesDocumentResult setEntities(List<Entity> entities) {
        this.entities = entities;
        return this;
    }

    @Override
    public EntitiesDocumentResult setId(String id) {
        super.setId(id);
        return this;
    }

    @Override
    public EntitiesDocumentResult setWarnings(List<DocumentWarning> warnings) {
        super.setWarnings(warnings);
        return this;
    }

    @Override
    public EntitiesDocumentResult setStatistics(DocumentStatistics statistics) {
        super.setStatistics(statistics);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.getId());
        jsonWriter.writeArrayField("warnings", this.getWarnings(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("statistics", (JsonSerializable)this.getStatistics());
        jsonWriter.writeArrayField("entities", this.entities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static EntitiesDocumentResult fromJson(JsonReader jsonReader) throws IOException {
        return (EntitiesDocumentResult)jsonReader.readObject(reader -> {
            EntitiesDocumentResult deserializedEntitiesDocumentResult = new EntitiesDocumentResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedEntitiesDocumentResult.setId(reader.getString());
                    continue;
                }
                if ("warnings".equals(fieldName)) {
                    List warnings = reader.readArray(reader1 -> DocumentWarning.fromJson(reader1));
                    deserializedEntitiesDocumentResult.setWarnings(warnings);
                    continue;
                }
                if ("statistics".equals(fieldName)) {
                    deserializedEntitiesDocumentResult.setStatistics(DocumentStatistics.fromJson(reader));
                    continue;
                }
                if ("entities".equals(fieldName)) {
                    List entities;
                    deserializedEntitiesDocumentResult.entities = entities = reader.readArray(reader1 -> Entity.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEntitiesDocumentResult;
        });
    }
}

