/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.DocumentError;
import com.azure.ai.textanalytics.implementation.models.MultiClassificationDocument;
import com.azure.ai.textanalytics.implementation.models.RequestStatistics;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class CustomMultiClassificationResult
implements JsonSerializable<CustomMultiClassificationResult> {
    private List<MultiClassificationDocument> documents;
    private List<DocumentError> errors;
    private RequestStatistics statistics;
    private String projectName;
    private String deploymentName;

    public List<MultiClassificationDocument> getDocuments() {
        return this.documents;
    }

    public CustomMultiClassificationResult setDocuments(List<MultiClassificationDocument> documents) {
        this.documents = documents;
        return this;
    }

    public List<DocumentError> getErrors() {
        return this.errors;
    }

    public CustomMultiClassificationResult setErrors(List<DocumentError> errors) {
        this.errors = errors;
        return this;
    }

    public RequestStatistics getStatistics() {
        return this.statistics;
    }

    public CustomMultiClassificationResult setStatistics(RequestStatistics statistics) {
        this.statistics = statistics;
        return this;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public CustomMultiClassificationResult setProjectName(String projectName) {
        this.projectName = projectName;
        return this;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public CustomMultiClassificationResult setDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("documents", this.documents, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("errors", this.errors, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("statistics", (JsonSerializable)this.statistics);
        jsonWriter.writeStringField("projectName", this.projectName);
        jsonWriter.writeStringField("deploymentName", this.deploymentName);
        return jsonWriter.writeEndObject();
    }

    public static CustomMultiClassificationResult fromJson(JsonReader jsonReader) throws IOException {
        return (CustomMultiClassificationResult)jsonReader.readObject(reader -> {
            CustomMultiClassificationResult deserializedCustomMultiClassificationResult = new CustomMultiClassificationResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("documents".equals(fieldName)) {
                    deserializedCustomMultiClassificationResult.documents = reader.readArray(reader1 -> MultiClassificationDocument.fromJson(reader1));
                    continue;
                }
                if ("errors".equals(fieldName)) {
                    deserializedCustomMultiClassificationResult.errors = reader.readArray(reader1 -> DocumentError.fromJson(reader1));
                    continue;
                }
                if ("statistics".equals(fieldName)) {
                    deserializedCustomMultiClassificationResult.statistics = RequestStatistics.fromJson(reader);
                    continue;
                }
                if ("projectName".equals(fieldName)) {
                    deserializedCustomMultiClassificationResult.projectName = reader.getString();
                    continue;
                }
                if ("deploymentName".equals(fieldName)) {
                    deserializedCustomMultiClassificationResult.deploymentName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomMultiClassificationResult;
        });
    }
}

