/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.AnalyzeTextEntityLinkingInput;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextEntityRecognitionInput;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextKeyPhraseExtractionInput;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLanguageDetectionInput;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextPiiEntitiesRecognitionInput;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextSentimentAnalysisInput;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextTaskKind;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public class AnalyzeTextTask
implements JsonSerializable<AnalyzeTextTask> {
    private AnalyzeTextTaskKind kind = AnalyzeTextTaskKind.fromString("AnalyzeTextTask");

    public AnalyzeTextTaskKind getKind() {
        return this.kind;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    public static AnalyzeTextTask fromJson(JsonReader jsonReader) throws IOException {
        return (AnalyzeTextTask)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                AnalyzeTextTask analyzeTextTask;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("kind".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("EntityLinking".equals(discriminatorValue)) {
                    analyzeTextTask = AnalyzeTextEntityLinkingInput.fromJson(readerToUse.reset());
                    return analyzeTextTask;
                }
                if ("EntityRecognition".equals(discriminatorValue)) {
                    analyzeTextTask = AnalyzeTextEntityRecognitionInput.fromJson(readerToUse.reset());
                    return analyzeTextTask;
                }
                if ("KeyPhraseExtraction".equals(discriminatorValue)) {
                    analyzeTextTask = AnalyzeTextKeyPhraseExtractionInput.fromJson(readerToUse.reset());
                    return analyzeTextTask;
                }
                if ("PiiEntityRecognition".equals(discriminatorValue)) {
                    analyzeTextTask = AnalyzeTextPiiEntitiesRecognitionInput.fromJson(readerToUse.reset());
                    return analyzeTextTask;
                }
                if ("LanguageDetection".equals(discriminatorValue)) {
                    analyzeTextTask = AnalyzeTextLanguageDetectionInput.fromJson(readerToUse.reset());
                    return analyzeTextTask;
                }
                if ("SentimentAnalysis".equals(discriminatorValue)) {
                    analyzeTextTask = AnalyzeTextSentimentAnalysisInput.fromJson(readerToUse.reset());
                    return analyzeTextTask;
                }
                analyzeTextTask = AnalyzeTextTask.fromJsonKnownDiscriminator(readerToUse.reset());
                return analyzeTextTask;
            }
        });
    }

    static AnalyzeTextTask fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (AnalyzeTextTask)jsonReader.readObject(reader -> {
            AnalyzeTextTask deserializedAnalyzeTextTask = new AnalyzeTextTask();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kind".equals(fieldName)) {
                    deserializedAnalyzeTextTask.kind = AnalyzeTextTaskKind.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAnalyzeTextTask;
        });
    }
}

