// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Authorization to copy a document model to the specified target resource and
 * modelId.
 */
@Immutable
public final class ModelCopyAuthorization implements JsonSerializable<ModelCopyAuthorization> {

    /*
     * ID of the target Azure resource where the document model should be copied to.
     */
    @Generated
    private final String targetResourceId;

    /*
     * Location of the target Azure resource where the document model should be copied
     * to.
     */
    @Generated
    private final String targetResourceRegion;

    /*
     * Identifier of the target document model.
     */
    @Generated
    private final String targetModelId;

    /*
     * URL of the copied document model in the target account.
     */
    @Generated
    private final String targetModelLocation;

    /*
     * Token used to authorize the request.
     */
    @Generated
    private final String accessToken;

    /*
     * Date/time when the access token expires.
     */
    @Generated
    private final OffsetDateTime expiresOn;

    /**
     * Creates an instance of ModelCopyAuthorization class.
     *
     * @param targetResourceId the targetResourceId value to set.
     * @param targetResourceRegion the targetResourceRegion value to set.
     * @param targetModelId the targetModelId value to set.
     * @param targetModelLocation the targetModelLocation value to set.
     * @param accessToken the accessToken value to set.
     * @param expiresOn the expiresOn value to set.
     */
    @Generated
    public ModelCopyAuthorization(String targetResourceId, String targetResourceRegion, String targetModelId,
        String targetModelLocation, String accessToken, OffsetDateTime expiresOn) {
        this.targetResourceId = targetResourceId;
        this.targetResourceRegion = targetResourceRegion;
        this.targetModelId = targetModelId;
        this.targetModelLocation = targetModelLocation;
        this.accessToken = accessToken;
        this.expiresOn = expiresOn;
    }

    /**
     * Get the targetResourceId property: ID of the target Azure resource where the document model should be copied to.
     *
     * @return the targetResourceId value.
     */
    @Generated
    public String getTargetResourceId() {
        return this.targetResourceId;
    }

    /**
     * Get the targetResourceRegion property: Location of the target Azure resource where the document model should be
     * copied
     * to.
     *
     * @return the targetResourceRegion value.
     */
    @Generated
    public String getTargetResourceRegion() {
        return this.targetResourceRegion;
    }

    /**
     * Get the targetModelId property: Identifier of the target document model.
     *
     * @return the targetModelId value.
     */
    @Generated
    public String getTargetModelId() {
        return this.targetModelId;
    }

    /**
     * Get the targetModelLocation property: URL of the copied document model in the target account.
     *
     * @return the targetModelLocation value.
     */
    @Generated
    public String getTargetModelLocation() {
        return this.targetModelLocation;
    }

    /**
     * Get the accessToken property: Token used to authorize the request.
     *
     * @return the accessToken value.
     */
    @Generated
    public String getAccessToken() {
        return this.accessToken;
    }

    /**
     * Get the expiresOn property: Date/time when the access token expires.
     *
     * @return the expiresOn value.
     */
    @Generated
    public OffsetDateTime getExpiresOn() {
        return this.expiresOn;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("targetResourceId", this.targetResourceId);
        jsonWriter.writeStringField("targetResourceRegion", this.targetResourceRegion);
        jsonWriter.writeStringField("targetModelId", this.targetModelId);
        jsonWriter.writeStringField("targetModelLocation", this.targetModelLocation);
        jsonWriter.writeStringField("accessToken", this.accessToken);
        jsonWriter.writeStringField("expirationDateTime",
            this.expiresOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expiresOn));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ModelCopyAuthorization from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ModelCopyAuthorization if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ModelCopyAuthorization.
     */
    @Generated
    public static ModelCopyAuthorization fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String targetResourceId = null;
            String targetResourceRegion = null;
            String targetModelId = null;
            String targetModelLocation = null;
            String accessToken = null;
            OffsetDateTime expiresOn = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targetResourceId".equals(fieldName)) {
                    targetResourceId = reader.getString();
                } else if ("targetResourceRegion".equals(fieldName)) {
                    targetResourceRegion = reader.getString();
                } else if ("targetModelId".equals(fieldName)) {
                    targetModelId = reader.getString();
                } else if ("targetModelLocation".equals(fieldName)) {
                    targetModelLocation = reader.getString();
                } else if ("accessToken".equals(fieldName)) {
                    accessToken = reader.getString();
                } else if ("expirationDateTime".equals(fieldName)) {
                    expiresOn = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }
            return new ModelCopyAuthorization(targetResourceId, targetResourceRegion, targetModelId,
                targetModelLocation, accessToken, expiresOn);
        });
    }
}
