// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

/**
 * Get Operation response object.
 */
@Immutable
public final class DocumentModelBuildOperationDetails extends DocumentIntelligenceOperationDetails {

    /*
     * Type of operation.
     */
    @Generated
    private OperationKind kind = OperationKind.DOCUMENT_MODEL_BUILD;

    /*
     * Operation result upon success.
     */
    @Generated
    private DocumentModelDetails result;

    /**
     * Creates an instance of DocumentModelBuildOperationDetails class.
     *
     * @param status the status value to set.
     * @param createdOn the createdOn value to set.
     * @param lastUpdatedOn the lastUpdatedOn value to set.
     * @param resourceLocation the resourceLocation value to set.
     */
    @Generated
    private DocumentModelBuildOperationDetails(DocumentIntelligenceOperationStatus status, OffsetDateTime createdOn,
        OffsetDateTime lastUpdatedOn, String resourceLocation) {
        super(status, createdOn, lastUpdatedOn, resourceLocation);
    }

    /**
     * Get the kind property: Type of operation.
     *
     * @return the kind value.
     */
    @Generated
    @Override
    public OperationKind getKind() {
        return this.kind;
    }

    /**
     * Get the result property: Operation result upon success.
     *
     * @return the result value.
     */
    @Generated
    public DocumentModelDetails getResult() {
        return this.result;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", getStatus() == null ? null : getStatus().toString());
        jsonWriter.writeStringField("createdDateTime",
            getCreatedOn() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(getCreatedOn()));
        jsonWriter.writeStringField("lastUpdatedDateTime",
            getLastUpdatedOn() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(getLastUpdatedOn()));
        jsonWriter.writeStringField("resourceLocation", getResourceLocation());
        jsonWriter.writeNumberField("percentCompleted", getPercentCompleted());
        jsonWriter.writeStringField("apiVersion", getApiVersion());
        jsonWriter.writeMapField("tags", getTags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("error", getError());
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeJsonField("result", this.result);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DocumentModelBuildOperationDetails from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of DocumentModelBuildOperationDetails if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DocumentModelBuildOperationDetails.
     */
    @Generated
    public static DocumentModelBuildOperationDetails fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String operationId = null;
            DocumentIntelligenceOperationStatus status = null;
            OffsetDateTime createdOn = null;
            OffsetDateTime lastUpdatedOn = null;
            String resourceLocation = null;
            Integer percentCompleted = null;
            String apiVersion = null;
            Map<String, String> tags = null;
            DocumentIntelligenceError error = null;
            OperationKind kind = OperationKind.DOCUMENT_MODEL_BUILD;
            DocumentModelDetails result = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("operationId".equals(fieldName)) {
                    operationId = reader.getString();
                } else if ("status".equals(fieldName)) {
                    status = DocumentIntelligenceOperationStatus.fromString(reader.getString());
                } else if ("createdDateTime".equals(fieldName)) {
                    createdOn = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("lastUpdatedDateTime".equals(fieldName)) {
                    lastUpdatedOn = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("resourceLocation".equals(fieldName)) {
                    resourceLocation = reader.getString();
                } else if ("percentCompleted".equals(fieldName)) {
                    percentCompleted = reader.getNullable(JsonReader::getInt);
                } else if ("apiVersion".equals(fieldName)) {
                    apiVersion = reader.getString();
                } else if ("tags".equals(fieldName)) {
                    tags = reader.readMap(reader1 -> reader1.getString());
                } else if ("error".equals(fieldName)) {
                    error = DocumentIntelligenceError.fromJson(reader);
                } else if ("kind".equals(fieldName)) {
                    kind = OperationKind.fromString(reader.getString());
                } else if ("result".equals(fieldName)) {
                    result = DocumentModelDetails.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            DocumentModelBuildOperationDetails deserializedDocumentModelBuildOperationDetails
                = new DocumentModelBuildOperationDetails(status, createdOn, lastUpdatedOn, resourceLocation);
            deserializedDocumentModelBuildOperationDetails.setOperationId(operationId);
            deserializedDocumentModelBuildOperationDetails.setPercentCompleted(percentCompleted);
            deserializedDocumentModelBuildOperationDetails.setApiVersion(apiVersion);
            deserializedDocumentModelBuildOperationDetails.setTags(tags);
            deserializedDocumentModelBuildOperationDetails.setError(error);
            deserializedDocumentModelBuildOperationDetails.kind = kind;
            deserializedDocumentModelBuildOperationDetails.result = result;
            return deserializedDocumentModelBuildOperationDetails;
        });
    }
}
