// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * An object representing the detected language for a given text span.
 */
@Immutable
public final class DocumentLanguage implements JsonSerializable<DocumentLanguage> {

    /*
     * Detected language. Value may an ISO 639-1 language code (ex. "en", "fr")
     * or BCP 47 language tag (ex. "zh-Hans").
     */
    @Generated
    private final String locale;

    /*
     * Location of the text elements in the concatenated content the language applies
     * to.
     */
    @Generated
    private final List<DocumentSpan> spans;

    /*
     * Confidence of correctly identifying the language.
     */
    @Generated
    private final double confidence;

    /**
     * Creates an instance of DocumentLanguage class.
     *
     * @param locale the locale value to set.
     * @param spans the spans value to set.
     * @param confidence the confidence value to set.
     */
    @Generated
    private DocumentLanguage(String locale, List<DocumentSpan> spans, double confidence) {
        this.locale = locale;
        this.spans = spans;
        this.confidence = confidence;
    }

    /**
     * Get the locale property: Detected language. Value may an ISO 639-1 language code (ex. "en", "fr")
     * or BCP 47 language tag (ex. "zh-Hans").
     *
     * @return the locale value.
     */
    @Generated
    public String getLocale() {
        return this.locale;
    }

    /**
     * Get the spans property: Location of the text elements in the concatenated content the language applies
     * to.
     *
     * @return the spans value.
     */
    @Generated
    public List<DocumentSpan> getSpans() {
        return this.spans;
    }

    /**
     * Get the confidence property: Confidence of correctly identifying the language.
     *
     * @return the confidence value.
     */
    @Generated
    public double getConfidence() {
        return this.confidence;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("locale", this.locale);
        jsonWriter.writeArrayField("spans", this.spans, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeDoubleField("confidence", this.confidence);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DocumentLanguage from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of DocumentLanguage if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DocumentLanguage.
     */
    @Generated
    public static DocumentLanguage fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String locale = null;
            List<DocumentSpan> spans = null;
            double confidence = 0.0;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("locale".equals(fieldName)) {
                    locale = reader.getString();
                } else if ("spans".equals(fieldName)) {
                    spans = reader.readArray(reader1 -> DocumentSpan.fromJson(reader1));
                } else if ("confidence".equals(fieldName)) {
                    confidence = reader.getDouble();
                } else {
                    reader.skipChildren();
                }
            }
            return new DocumentLanguage(locale, spans, confidence);
        });
    }
}
