// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The error object.
 */
@Immutable
public final class DocumentIntelligenceWarning implements JsonSerializable<DocumentIntelligenceWarning> {

    /*
     * One of a server-defined set of warning codes.
     */
    @Generated
    private final String code;

    /*
     * A human-readable representation of the warning.
     */
    @Generated
    private final String message;

    /*
     * The target of the error.
     */
    @Generated
    private String target;

    /**
     * Creates an instance of DocumentIntelligenceWarning class.
     *
     * @param code the code value to set.
     * @param message the message value to set.
     */
    @Generated
    private DocumentIntelligenceWarning(String code, String message) {
        this.code = code;
        this.message = message;
    }

    /**
     * Get the code property: One of a server-defined set of warning codes.
     *
     * @return the code value.
     */
    @Generated
    public String getCode() {
        return this.code;
    }

    /**
     * Get the message property: A human-readable representation of the warning.
     *
     * @return the message value.
     */
    @Generated
    public String getMessage() {
        return this.message;
    }

    /**
     * Get the target property: The target of the error.
     *
     * @return the target value.
     */
    @Generated
    public String getTarget() {
        return this.target;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeStringField("target", this.target);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DocumentIntelligenceWarning from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of DocumentIntelligenceWarning if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DocumentIntelligenceWarning.
     */
    @Generated
    public static DocumentIntelligenceWarning fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String code = null;
            String message = null;
            String target = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equals(fieldName)) {
                    code = reader.getString();
                } else if ("message".equals(fieldName)) {
                    message = reader.getString();
                } else if ("target".equals(fieldName)) {
                    target = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            DocumentIntelligenceWarning deserializedDocumentIntelligenceWarning
                = new DocumentIntelligenceWarning(code, message);
            deserializedDocumentIntelligenceWarning.target = target;
            return deserializedDocumentIntelligenceWarning;
        });
    }
}
