// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Format of the content in analyzed result.
 */
public final class DocumentContentFormat extends ExpandableStringEnum<DocumentContentFormat> {

    /**
     * Plain text representation of the document content without any formatting.
     */
    @Generated
    public static final DocumentContentFormat TEXT = fromString("text");

    /**
     * Markdown representation of the document content with section headings, tables,
     * etc.
     */
    @Generated
    public static final DocumentContentFormat MARKDOWN = fromString("markdown");

    /**
     * Creates a new instance of DocumentContentFormat value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public DocumentContentFormat() {
    }

    /**
     * Creates or finds a DocumentContentFormat from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding DocumentContentFormat.
     */
    @Generated
    public static DocumentContentFormat fromString(String name) {
        return fromString(name, DocumentContentFormat.class);
    }

    /**
     * Gets known DocumentContentFormat values.
     *
     * @return known DocumentContentFormat values.
     */
    @Generated
    public static Collection<DocumentContentFormat> values() {
        return values(DocumentContentFormat.class);
    }
}
