/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence;

import com.azure.ai.documentintelligence.DocumentIntelligenceAdministrationClientBuilder;
import com.azure.ai.documentintelligence.implementation.DocumentIntelligenceAdministrationClientImpl;
import com.azure.ai.documentintelligence.models.AuthorizeClassifierCopyOptions;
import com.azure.ai.documentintelligence.models.AuthorizeModelCopyOptions;
import com.azure.ai.documentintelligence.models.BuildDocumentClassifierOptions;
import com.azure.ai.documentintelligence.models.BuildDocumentModelOptions;
import com.azure.ai.documentintelligence.models.ClassifierCopyAuthorization;
import com.azure.ai.documentintelligence.models.ComposeDocumentModelOptions;
import com.azure.ai.documentintelligence.models.DocumentClassifierBuildOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentClassifierCopyToOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentClassifierDetails;
import com.azure.ai.documentintelligence.models.DocumentIntelligenceOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentIntelligenceResourceDetails;
import com.azure.ai.documentintelligence.models.DocumentModelBuildOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentModelComposeOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentModelCopyToOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentModelDetails;
import com.azure.ai.documentintelligence.models.ModelCopyAuthorization;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.polling.SyncPoller;

@ServiceClient(builder=DocumentIntelligenceAdministrationClientBuilder.class)
public final class DocumentIntelligenceAdministrationClient {
    private final DocumentIntelligenceAdministrationClientImpl serviceClient;

    DocumentIntelligenceAdministrationClient(DocumentIntelligenceAdministrationClientImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginBuildDocumentModel(BinaryData buildRequest, RequestOptions requestOptions) {
        return this.serviceClient.beginBuildDocumentModel(buildRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginComposeModel(BinaryData composeRequest, RequestOptions requestOptions) {
        return this.serviceClient.beginComposeModel(composeRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> authorizeModelCopyWithResponse(BinaryData authorizeCopyRequest, RequestOptions requestOptions) {
        return this.serviceClient.authorizeModelCopyWithResponse(authorizeCopyRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginCopyModelTo(String modelId, BinaryData copyToRequest, RequestOptions requestOptions) {
        return this.serviceClient.beginCopyModelTo(modelId, copyToRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getModelWithResponse(String modelId, RequestOptions requestOptions) {
        return this.serviceClient.getModelWithResponse(modelId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listModels(RequestOptions requestOptions) {
        return this.serviceClient.listModels(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteModelWithResponse(String modelId, RequestOptions requestOptions) {
        return this.serviceClient.deleteModelWithResponse(modelId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getResourceDetailsWithResponse(RequestOptions requestOptions) {
        return this.serviceClient.getResourceDetailsWithResponse(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getOperationWithResponse(String operationId, RequestOptions requestOptions) {
        return this.serviceClient.getOperationWithResponse(operationId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listOperations(RequestOptions requestOptions) {
        return this.serviceClient.listOperations(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginBuildClassifier(BinaryData buildRequest, RequestOptions requestOptions) {
        return this.serviceClient.beginBuildClassifier(buildRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> authorizeClassifierCopyWithResponse(BinaryData authorizeCopyRequest, RequestOptions requestOptions) {
        return this.serviceClient.authorizeClassifierCopyWithResponse(authorizeCopyRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginCopyClassifierTo(String classifierId, BinaryData copyToRequest, RequestOptions requestOptions) {
        return this.serviceClient.beginCopyClassifierTo(classifierId, copyToRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getClassifierWithResponse(String classifierId, RequestOptions requestOptions) {
        return this.serviceClient.getClassifierWithResponse(classifierId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listClassifiers(RequestOptions requestOptions) {
        return this.serviceClient.listClassifiers(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteClassifierWithResponse(String classifierId, RequestOptions requestOptions) {
        return this.serviceClient.deleteClassifierWithResponse(classifierId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DocumentModelBuildOperationDetails, DocumentModelDetails> beginBuildDocumentModel(BuildDocumentModelOptions buildRequest) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.beginBuildDocumentModelWithModel(BinaryData.fromObject((Object)buildRequest), requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ModelCopyAuthorization authorizeModelCopy(AuthorizeModelCopyOptions authorizeCopyRequest) {
        RequestOptions requestOptions = new RequestOptions();
        return (ModelCopyAuthorization)((BinaryData)this.authorizeModelCopyWithResponse(BinaryData.fromObject((Object)authorizeCopyRequest), requestOptions).getValue()).toObject(ModelCopyAuthorization.class);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DocumentModelCopyToOperationDetails, DocumentModelDetails> beginCopyModelTo(String modelId, ModelCopyAuthorization copyToRequest) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.beginCopyModelToWithModel(modelId, BinaryData.fromObject((Object)copyToRequest), requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DocumentModelDetails getModel(String modelId) {
        RequestOptions requestOptions = new RequestOptions();
        return (DocumentModelDetails)((BinaryData)this.getModelWithResponse(modelId, requestOptions).getValue()).toObject(DocumentModelDetails.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DocumentModelDetails> listModels() {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listModels(requestOptions).mapPage(bodyItemValue -> (DocumentModelDetails)bodyItemValue.toObject(DocumentModelDetails.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteModel(String modelId) {
        RequestOptions requestOptions = new RequestOptions();
        this.deleteModelWithResponse(modelId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DocumentIntelligenceResourceDetails getResourceDetails() {
        RequestOptions requestOptions = new RequestOptions();
        return (DocumentIntelligenceResourceDetails)((BinaryData)this.getResourceDetailsWithResponse(requestOptions).getValue()).toObject(DocumentIntelligenceResourceDetails.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DocumentIntelligenceOperationDetails getOperation(String operationId) {
        RequestOptions requestOptions = new RequestOptions();
        return (DocumentIntelligenceOperationDetails)((BinaryData)this.getOperationWithResponse(operationId, requestOptions).getValue()).toObject(DocumentIntelligenceOperationDetails.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DocumentIntelligenceOperationDetails> listOperations() {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listOperations(requestOptions).mapPage(bodyItemValue -> (DocumentIntelligenceOperationDetails)bodyItemValue.toObject(DocumentIntelligenceOperationDetails.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DocumentClassifierBuildOperationDetails, DocumentClassifierDetails> beginBuildClassifier(BuildDocumentClassifierOptions buildRequest) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.beginBuildClassifierWithModel(BinaryData.fromObject((Object)buildRequest), requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ClassifierCopyAuthorization authorizeClassifierCopy(AuthorizeClassifierCopyOptions authorizeCopyRequest) {
        RequestOptions requestOptions = new RequestOptions();
        return (ClassifierCopyAuthorization)((BinaryData)this.authorizeClassifierCopyWithResponse(BinaryData.fromObject((Object)authorizeCopyRequest), requestOptions).getValue()).toObject(ClassifierCopyAuthorization.class);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DocumentClassifierCopyToOperationDetails, DocumentClassifierDetails> beginCopyClassifierTo(String classifierId, ClassifierCopyAuthorization copyToRequest) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.beginCopyClassifierToWithModel(classifierId, BinaryData.fromObject((Object)copyToRequest), requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DocumentClassifierDetails getClassifier(String classifierId) {
        RequestOptions requestOptions = new RequestOptions();
        return (DocumentClassifierDetails)((BinaryData)this.getClassifierWithResponse(classifierId, requestOptions).getValue()).toObject(DocumentClassifierDetails.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DocumentClassifierDetails> listClassifiers() {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listClassifiers(requestOptions).mapPage(bodyItemValue -> (DocumentClassifierDetails)bodyItemValue.toObject(DocumentClassifierDetails.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteClassifier(String classifierId) {
        RequestOptions requestOptions = new RequestOptions();
        this.deleteClassifierWithResponse(classifierId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DocumentModelComposeOperationDetails, DocumentModelDetails> beginComposeModel(ComposeDocumentModelOptions composeRequest) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.beginComposeModelWithModel(BinaryData.fromObject((Object)composeRequest), requestOptions);
    }
}

