/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.DocumentSelectionMarkState;
import com.azure.ai.documentintelligence.models.DocumentSpan;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class DocumentSelectionMark
implements JsonSerializable<DocumentSelectionMark> {
    private final DocumentSelectionMarkState state;
    private List<Double> polygon;
    private final DocumentSpan span;
    private final double confidence;

    private DocumentSelectionMark(DocumentSelectionMarkState state, DocumentSpan span, double confidence) {
        this.state = state;
        this.span = span;
        this.confidence = confidence;
    }

    public DocumentSelectionMarkState getState() {
        return this.state;
    }

    public List<Double> getPolygon() {
        return this.polygon;
    }

    public DocumentSpan getSpan() {
        return this.span;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeJsonField("span", (JsonSerializable)this.span);
        jsonWriter.writeDoubleField("confidence", this.confidence);
        jsonWriter.writeArrayField("polygon", this.polygon, (writer, element) -> writer.writeDouble(element.doubleValue()));
        return jsonWriter.writeEndObject();
    }

    public static DocumentSelectionMark fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentSelectionMark)jsonReader.readObject(reader -> {
            DocumentSelectionMarkState state = null;
            DocumentSpan span = null;
            double confidence = 0.0;
            List polygon = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("state".equals(fieldName)) {
                    state = DocumentSelectionMarkState.fromString(reader.getString());
                    continue;
                }
                if ("span".equals(fieldName)) {
                    span = DocumentSpan.fromJson(reader);
                    continue;
                }
                if ("confidence".equals(fieldName)) {
                    confidence = reader.getDouble();
                    continue;
                }
                if ("polygon".equals(fieldName)) {
                    polygon = reader.readArray(reader1 -> reader1.getDouble());
                    continue;
                }
                reader.skipChildren();
            }
            DocumentSelectionMark deserializedDocumentSelectionMark = new DocumentSelectionMark(state, span, confidence);
            deserializedDocumentSelectionMark.polygon = polygon;
            return deserializedDocumentSelectionMark;
        });
    }
}

