/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class AzureBlobContentSource
implements JsonSerializable<AzureBlobContentSource> {
    private final String containerUrl;
    private String prefix;

    public AzureBlobContentSource(String containerUrl) {
        this.containerUrl = containerUrl;
    }

    public String getContainerUrl() {
        return this.containerUrl;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public AzureBlobContentSource setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("containerUrl", this.containerUrl);
        jsonWriter.writeStringField("prefix", this.prefix);
        return jsonWriter.writeEndObject();
    }

    public static AzureBlobContentSource fromJson(JsonReader jsonReader) throws IOException {
        return (AzureBlobContentSource)jsonReader.readObject(reader -> {
            String containerUrl = null;
            String prefix = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("containerUrl".equals(fieldName)) {
                    containerUrl = reader.getString();
                    continue;
                }
                if ("prefix".equals(fieldName)) {
                    prefix = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            AzureBlobContentSource deserializedAzureBlobContentSource = new AzureBlobContentSource(containerUrl);
            deserializedAzureBlobContentSource.prefix = prefix;
            return deserializedAzureBlobContentSource;
        });
    }
}

