/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.DocumentIntelligenceError;
import com.azure.ai.documentintelligence.models.DocumentIntelligenceOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentIntelligenceOperationStatus;
import com.azure.ai.documentintelligence.models.DocumentModelDetails;
import com.azure.ai.documentintelligence.models.OperationKind;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public final class DocumentModelComposeOperationDetails
extends DocumentIntelligenceOperationDetails {
    private OperationKind kind = OperationKind.DOCUMENT_MODEL_COMPOSE;
    private DocumentModelDetails result;

    private DocumentModelComposeOperationDetails(DocumentIntelligenceOperationStatus status, OffsetDateTime createdOn, OffsetDateTime lastUpdatedOn, String resourceLocation) {
        super(status, createdOn, lastUpdatedOn, resourceLocation);
    }

    @Override
    public OperationKind getKind() {
        return this.kind;
    }

    public DocumentModelDetails getResult() {
        return this.result;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.getStatus() == null ? null : this.getStatus().toString());
        jsonWriter.writeStringField("createdDateTime", this.getCreatedOn() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.getCreatedOn()));
        jsonWriter.writeStringField("lastUpdatedDateTime", this.getLastUpdatedOn() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.getLastUpdatedOn()));
        jsonWriter.writeStringField("resourceLocation", this.getResourceLocation());
        jsonWriter.writeNumberField("percentCompleted", (Number)this.getPercentCompleted());
        jsonWriter.writeStringField("apiVersion", this.getApiVersion());
        jsonWriter.writeMapField("tags", this.getTags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("error", (JsonSerializable)this.getError());
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeJsonField("result", (JsonSerializable)this.result);
        return jsonWriter.writeEndObject();
    }

    public static DocumentModelComposeOperationDetails fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentModelComposeOperationDetails)jsonReader.readObject(reader -> {
            String operationId = null;
            DocumentIntelligenceOperationStatus status = null;
            OffsetDateTime createdOn = null;
            OffsetDateTime lastUpdatedOn = null;
            String resourceLocation = null;
            Integer percentCompleted = null;
            String apiVersion = null;
            Map tags = null;
            DocumentIntelligenceError error = null;
            OperationKind kind = OperationKind.DOCUMENT_MODEL_COMPOSE;
            DocumentModelDetails result = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("operationId".equals(fieldName)) {
                    operationId = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    status = DocumentIntelligenceOperationStatus.fromString(reader.getString());
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    createdOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastUpdatedDateTime".equals(fieldName)) {
                    lastUpdatedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("resourceLocation".equals(fieldName)) {
                    resourceLocation = reader.getString();
                    continue;
                }
                if ("percentCompleted".equals(fieldName)) {
                    percentCompleted = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("apiVersion".equals(fieldName)) {
                    apiVersion = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("error".equals(fieldName)) {
                    error = DocumentIntelligenceError.fromJson(reader);
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    kind = OperationKind.fromString(reader.getString());
                    continue;
                }
                if ("result".equals(fieldName)) {
                    result = DocumentModelDetails.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            DocumentModelComposeOperationDetails deserializedDocumentModelComposeOperationDetails = new DocumentModelComposeOperationDetails(status, createdOn, lastUpdatedOn, resourceLocation);
            deserializedDocumentModelComposeOperationDetails.setOperationId(operationId);
            deserializedDocumentModelComposeOperationDetails.setPercentCompleted(percentCompleted);
            deserializedDocumentModelComposeOperationDetails.setApiVersion(apiVersion);
            deserializedDocumentModelComposeOperationDetails.setTags(tags);
            deserializedDocumentModelComposeOperationDetails.setError(error);
            deserializedDocumentModelComposeOperationDetails.kind = kind;
            deserializedDocumentModelComposeOperationDetails.result = result;
            return deserializedDocumentModelComposeOperationDetails;
        });
    }
}

