/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class QuotaDetails
implements JsonSerializable<QuotaDetails> {
    private final int used;
    private final int quota;
    private final OffsetDateTime quotaResetDateTime;

    private QuotaDetails(int used, int quota, OffsetDateTime quotaResetDateTime) {
        this.used = used;
        this.quota = quota;
        this.quotaResetDateTime = quotaResetDateTime;
    }

    public int getUsed() {
        return this.used;
    }

    public int getQuota() {
        return this.quota;
    }

    public OffsetDateTime getQuotaResetDateTime() {
        return this.quotaResetDateTime;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("used", this.used);
        jsonWriter.writeIntField("quota", this.quota);
        jsonWriter.writeStringField("quotaResetDateTime", this.quotaResetDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.quotaResetDateTime));
        return jsonWriter.writeEndObject();
    }

    public static QuotaDetails fromJson(JsonReader jsonReader) throws IOException {
        return (QuotaDetails)jsonReader.readObject(reader -> {
            int used = 0;
            int quota = 0;
            OffsetDateTime quotaResetDateTime = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("used".equals(fieldName)) {
                    used = reader.getInt();
                    continue;
                }
                if ("quota".equals(fieldName)) {
                    quota = reader.getInt();
                    continue;
                }
                if ("quotaResetDateTime".equals(fieldName)) {
                    quotaResetDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return new QuotaDetails(used, quota, quotaResetDateTime);
        });
    }
}

