/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.DocumentTypeDetails;
import com.azure.ai.documentintelligence.models.SplitMode;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class ComposeDocumentModelRequest
implements JsonSerializable<ComposeDocumentModelRequest> {
    private final String modelId;
    private String description;
    private final String classifierId;
    private SplitMode split;
    private final Map<String, DocumentTypeDetails> docTypes;
    private Map<String, String> tags;

    public ComposeDocumentModelRequest(String modelId, String classifierId, Map<String, DocumentTypeDetails> docTypes) {
        this.modelId = modelId;
        this.classifierId = classifierId;
        this.docTypes = docTypes;
    }

    public String getModelId() {
        return this.modelId;
    }

    public String getDescription() {
        return this.description;
    }

    public ComposeDocumentModelRequest setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getClassifierId() {
        return this.classifierId;
    }

    public SplitMode getSplit() {
        return this.split;
    }

    public ComposeDocumentModelRequest setSplit(SplitMode split) {
        this.split = split;
        return this;
    }

    public Map<String, DocumentTypeDetails> getDocTypes() {
        return this.docTypes;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public ComposeDocumentModelRequest setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("modelId", this.modelId);
        jsonWriter.writeStringField("classifierId", this.classifierId);
        jsonWriter.writeMapField("docTypes", this.docTypes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("split", this.split == null ? null : this.split.toString());
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ComposeDocumentModelRequest fromJson(JsonReader jsonReader) throws IOException {
        return (ComposeDocumentModelRequest)jsonReader.readObject(reader -> {
            String modelId = null;
            String classifierId = null;
            Map docTypes = null;
            String description = null;
            SplitMode split = null;
            Map tags = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("modelId".equals(fieldName)) {
                    modelId = reader.getString();
                    continue;
                }
                if ("classifierId".equals(fieldName)) {
                    classifierId = reader.getString();
                    continue;
                }
                if ("docTypes".equals(fieldName)) {
                    docTypes = reader.readMap(reader1 -> DocumentTypeDetails.fromJson(reader1));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("split".equals(fieldName)) {
                    split = SplitMode.fromString(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            ComposeDocumentModelRequest deserializedComposeDocumentModelRequest = new ComposeDocumentModelRequest(modelId, classifierId, docTypes);
            deserializedComposeDocumentModelRequest.description = description;
            deserializedComposeDocumentModelRequest.split = split;
            deserializedComposeDocumentModelRequest.tags = tags;
            return deserializedComposeDocumentModelRequest;
        });
    }
}

