/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.AnalyzeBatchOperationDetail;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class AnalyzeBatchResult
implements JsonSerializable<AnalyzeBatchResult> {
    private final int succeededCount;
    private final int failedCount;
    private final int skippedCount;
    private final List<AnalyzeBatchOperationDetail> details;

    private AnalyzeBatchResult(int succeededCount, int failedCount, int skippedCount, List<AnalyzeBatchOperationDetail> details) {
        this.succeededCount = succeededCount;
        this.failedCount = failedCount;
        this.skippedCount = skippedCount;
        this.details = details;
    }

    public int getSucceededCount() {
        return this.succeededCount;
    }

    public int getFailedCount() {
        return this.failedCount;
    }

    public int getSkippedCount() {
        return this.skippedCount;
    }

    public List<AnalyzeBatchOperationDetail> getDetails() {
        return this.details;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("succeededCount", this.succeededCount);
        jsonWriter.writeIntField("failedCount", this.failedCount);
        jsonWriter.writeIntField("skippedCount", this.skippedCount);
        jsonWriter.writeArrayField("details", this.details, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static AnalyzeBatchResult fromJson(JsonReader jsonReader) throws IOException {
        return (AnalyzeBatchResult)jsonReader.readObject(reader -> {
            int succeededCount = 0;
            int failedCount = 0;
            int skippedCount = 0;
            List details = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("succeededCount".equals(fieldName)) {
                    succeededCount = reader.getInt();
                    continue;
                }
                if ("failedCount".equals(fieldName)) {
                    failedCount = reader.getInt();
                    continue;
                }
                if ("skippedCount".equals(fieldName)) {
                    skippedCount = reader.getInt();
                    continue;
                }
                if ("details".equals(fieldName)) {
                    details = reader.readArray(reader1 -> AnalyzeBatchOperationDetail.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return new AnalyzeBatchResult(succeededCount, failedCount, skippedCount, details);
        });
    }
}

