/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.implementation;

import com.azure.ai.documentintelligence.DocumentIntelligenceServiceVersion;
import com.azure.ai.documentintelligence.implementation.OperationLocationPollingStrategy;
import com.azure.ai.documentintelligence.implementation.SyncOperationLocationPollingStrategy;
import com.azure.ai.documentintelligence.models.AnalyzeBatchResult;
import com.azure.ai.documentintelligence.models.AnalyzeBatchResultOperation;
import com.azure.ai.documentintelligence.models.AnalyzeResult;
import com.azure.ai.documentintelligence.models.AnalyzeResultOperation;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingStrategyOptions;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.TypeReference;
import java.time.Duration;
import reactor.core.publisher.Mono;

public final class DocumentIntelligenceClientImpl {
    private final DocumentIntelligenceClientService service;
    private final String endpoint;
    private final DocumentIntelligenceServiceVersion serviceVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;

    public String getEndpoint() {
        return this.endpoint;
    }

    public DocumentIntelligenceServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public DocumentIntelligenceClientImpl(String endpoint, DocumentIntelligenceServiceVersion serviceVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    public DocumentIntelligenceClientImpl(HttpPipeline httpPipeline, String endpoint, DocumentIntelligenceServiceVersion serviceVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    public DocumentIntelligenceClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint, DocumentIntelligenceServiceVersion serviceVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.serviceVersion = serviceVersion;
        this.service = (DocumentIntelligenceClientService)RestProxy.create(DocumentIntelligenceClientService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> analyzeDocumentWithResponseAsync(String modelId, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        RequestOptions requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
        requestOptionsLocal.addRequestCallback(requestLocal -> {
            if (requestLocal.getBody() != null && requestLocal.getHeaders().get(HttpHeaderName.CONTENT_TYPE) == null) {
                requestLocal.getHeaders().set(HttpHeaderName.CONTENT_TYPE, "application/json");
            }
        });
        return FluxUtil.withContext(context -> this.service.analyzeDocument(this.getEndpoint(), this.getServiceVersion().getVersion(), modelId, "application/json", "application/json", requestOptionsLocal, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<Void> analyzeDocumentWithResponse(String modelId, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        RequestOptions requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
        requestOptionsLocal.addRequestCallback(requestLocal -> {
            if (requestLocal.getBody() != null && requestLocal.getHeaders().get(HttpHeaderName.CONTENT_TYPE) == null) {
                requestLocal.getHeaders().set(HttpHeaderName.CONTENT_TYPE, "application/json");
            }
        });
        return this.service.analyzeDocumentSync(this.getEndpoint(), this.getServiceVersion().getVersion(), modelId, "application/json", "application/json", requestOptionsLocal, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentAsync(String modelId, RequestOptions requestOptions) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentWithResponseAsync(modelId, requestOptions), new OperationLocationPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion()), "analyzeResult"), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginAnalyzeDocument(String modelId, RequestOptions requestOptions) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentWithResponse(modelId, requestOptions), new SyncOperationLocationPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion()), "analyzeResult"), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<AnalyzeResultOperation, AnalyzeResult> beginAnalyzeDocumentWithModelAsync(String modelId, RequestOptions requestOptions) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentWithResponseAsync(modelId, requestOptions), new OperationLocationPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion()), "analyzeResult"), (TypeReference)TypeReference.createInstance(AnalyzeResultOperation.class), (TypeReference)TypeReference.createInstance(AnalyzeResult.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<AnalyzeResultOperation, AnalyzeResult> beginAnalyzeDocumentWithModel(String modelId, RequestOptions requestOptions) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentWithResponse(modelId, requestOptions), new SyncOperationLocationPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion()), "analyzeResult"), (TypeReference)TypeReference.createInstance(AnalyzeResultOperation.class), (TypeReference)TypeReference.createInstance(AnalyzeResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> analyzeBatchDocumentsWithResponseAsync(String modelId, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        RequestOptions requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
        requestOptionsLocal.addRequestCallback(requestLocal -> {
            if (requestLocal.getBody() != null && requestLocal.getHeaders().get(HttpHeaderName.CONTENT_TYPE) == null) {
                requestLocal.getHeaders().set(HttpHeaderName.CONTENT_TYPE, "application/json");
            }
        });
        return FluxUtil.withContext(context -> this.service.analyzeBatchDocuments(this.getEndpoint(), this.getServiceVersion().getVersion(), modelId, "application/json", "application/json", requestOptionsLocal, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<Void> analyzeBatchDocumentsWithResponse(String modelId, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        RequestOptions requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
        requestOptionsLocal.addRequestCallback(requestLocal -> {
            if (requestLocal.getBody() != null && requestLocal.getHeaders().get(HttpHeaderName.CONTENT_TYPE) == null) {
                requestLocal.getHeaders().set(HttpHeaderName.CONTENT_TYPE, "application/json");
            }
        });
        return this.service.analyzeBatchDocumentsSync(this.getEndpoint(), this.getServiceVersion().getVersion(), modelId, "application/json", "application/json", requestOptionsLocal, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeBatchDocumentsAsync(String modelId, RequestOptions requestOptions) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.analyzeBatchDocumentsWithResponseAsync(modelId, requestOptions), new OperationLocationPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion()), "result"), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginAnalyzeBatchDocuments(String modelId, RequestOptions requestOptions) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.analyzeBatchDocumentsWithResponse(modelId, requestOptions), new SyncOperationLocationPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion()), "result"), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<AnalyzeBatchResultOperation, AnalyzeBatchResult> beginAnalyzeBatchDocumentsWithModelAsync(String modelId, RequestOptions requestOptions) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.analyzeBatchDocumentsWithResponseAsync(modelId, requestOptions), new OperationLocationPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion()), "result"), (TypeReference)TypeReference.createInstance(AnalyzeBatchResultOperation.class), (TypeReference)TypeReference.createInstance(AnalyzeBatchResult.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<AnalyzeBatchResultOperation, AnalyzeBatchResult> beginAnalyzeBatchDocumentsWithModel(String modelId, RequestOptions requestOptions) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.analyzeBatchDocumentsWithResponse(modelId, requestOptions), new SyncOperationLocationPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion()), "result"), (TypeReference)TypeReference.createInstance(AnalyzeBatchResultOperation.class), (TypeReference)TypeReference.createInstance(AnalyzeBatchResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getAnalyzeResultPdfWithResponseAsync(String modelId, String resultId, RequestOptions requestOptions) {
        String accept = "application/pdf, application/json";
        return FluxUtil.withContext(context -> this.service.getAnalyzeResultPdf(this.getEndpoint(), this.getServiceVersion().getVersion(), modelId, resultId, "application/pdf, application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getAnalyzeResultPdfWithResponse(String modelId, String resultId, RequestOptions requestOptions) {
        String accept = "application/pdf, application/json";
        return this.service.getAnalyzeResultPdfSync(this.getEndpoint(), this.getServiceVersion().getVersion(), modelId, resultId, "application/pdf, application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getAnalyzeResultFigureWithResponseAsync(String modelId, String resultId, String figureId, RequestOptions requestOptions) {
        String accept = "image/png, application/json";
        return FluxUtil.withContext(context -> this.service.getAnalyzeResultFigure(this.getEndpoint(), this.getServiceVersion().getVersion(), modelId, resultId, figureId, "image/png, application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getAnalyzeResultFigureWithResponse(String modelId, String resultId, String figureId, RequestOptions requestOptions) {
        String accept = "image/png, application/json";
        return this.service.getAnalyzeResultFigureSync(this.getEndpoint(), this.getServiceVersion().getVersion(), modelId, resultId, figureId, "image/png, application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> classifyDocumentWithResponseAsync(String classifierId, BinaryData classifyRequest, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.classifyDocument(this.getEndpoint(), this.getServiceVersion().getVersion(), classifierId, "application/json", "application/json", classifyRequest, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<Void> classifyDocumentWithResponse(String classifierId, BinaryData classifyRequest, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.classifyDocumentSync(this.getEndpoint(), this.getServiceVersion().getVersion(), classifierId, "application/json", "application/json", classifyRequest, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginClassifyDocumentAsync(String classifierId, BinaryData classifyRequest, RequestOptions requestOptions) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.classifyDocumentWithResponseAsync(classifierId, classifyRequest, requestOptions), new OperationLocationPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion()), "analyzeResult"), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginClassifyDocument(String classifierId, BinaryData classifyRequest, RequestOptions requestOptions) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.classifyDocumentWithResponse(classifierId, classifyRequest, requestOptions), new SyncOperationLocationPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion()), "analyzeResult"), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<AnalyzeResultOperation, AnalyzeResult> beginClassifyDocumentWithModelAsync(String classifierId, BinaryData classifyRequest, RequestOptions requestOptions) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.classifyDocumentWithResponseAsync(classifierId, classifyRequest, requestOptions), new OperationLocationPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion()), "analyzeResult"), (TypeReference)TypeReference.createInstance(AnalyzeResultOperation.class), (TypeReference)TypeReference.createInstance(AnalyzeResult.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<AnalyzeResultOperation, AnalyzeResult> beginClassifyDocumentWithModel(String classifierId, BinaryData classifyRequest, RequestOptions requestOptions) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.classifyDocumentWithResponse(classifierId, classifyRequest, requestOptions), new SyncOperationLocationPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion()), "analyzeResult"), (TypeReference)TypeReference.createInstance(AnalyzeResultOperation.class), (TypeReference)TypeReference.createInstance(AnalyzeResult.class));
    }

    @Host(value="{endpoint}/documentintelligence")
    @ServiceInterface(name="DocumentIntelligence")
    public static interface DocumentIntelligenceClientService {
        @Post(value="/documentModels/{modelId}:analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> analyzeDocument(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="modelId") String var3, @HeaderParam(value="content-type") String var4, @HeaderParam(value="accept") String var5, RequestOptions var6, Context var7);

        @Post(value="/documentModels/{modelId}:analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> analyzeDocumentSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="modelId") String var3, @HeaderParam(value="content-type") String var4, @HeaderParam(value="accept") String var5, RequestOptions var6, Context var7);

        @Post(value="/documentModels/{modelId}:analyzeBatch")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> analyzeBatchDocuments(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="modelId") String var3, @HeaderParam(value="content-type") String var4, @HeaderParam(value="accept") String var5, RequestOptions var6, Context var7);

        @Post(value="/documentModels/{modelId}:analyzeBatch")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> analyzeBatchDocumentsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="modelId") String var3, @HeaderParam(value="content-type") String var4, @HeaderParam(value="accept") String var5, RequestOptions var6, Context var7);

        @Get(value="/documentModels/{modelId}/analyzeResults/{resultId}/pdf")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getAnalyzeResultPdf(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="modelId") String var3, @PathParam(value="resultId") String var4, @HeaderParam(value="accept") String var5, RequestOptions var6, Context var7);

        @Get(value="/documentModels/{modelId}/analyzeResults/{resultId}/pdf")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getAnalyzeResultPdfSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="modelId") String var3, @PathParam(value="resultId") String var4, @HeaderParam(value="accept") String var5, RequestOptions var6, Context var7);

        @Get(value="/documentModels/{modelId}/analyzeResults/{resultId}/figures/{figureId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getAnalyzeResultFigure(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="modelId") String var3, @PathParam(value="resultId") String var4, @PathParam(value="figureId") String var5, @HeaderParam(value="accept") String var6, RequestOptions var7, Context var8);

        @Get(value="/documentModels/{modelId}/analyzeResults/{resultId}/figures/{figureId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getAnalyzeResultFigureSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="modelId") String var3, @PathParam(value="resultId") String var4, @PathParam(value="figureId") String var5, @HeaderParam(value="accept") String var6, RequestOptions var7, Context var8);

        @Post(value="/documentClassifiers/{classifierId}:analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> classifyDocument(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="classifierId") String var3, @HeaderParam(value="content-type") String var4, @HeaderParam(value="accept") String var5, @BodyParam(value="application/json") BinaryData var6, RequestOptions var7, Context var8);

        @Post(value="/documentClassifiers/{classifierId}:analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> classifyDocumentSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="classifierId") String var3, @HeaderParam(value="content-type") String var4, @HeaderParam(value="accept") String var5, @BodyParam(value="application/json") BinaryData var6, RequestOptions var7, Context var8);
    }
}

