// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/**
 * Quota used, limit, and next reset date/time.
 */
@Immutable
public final class QuotaDetails {
    /*
     * Amount of the resource quota used.
     */
    @Generated
    @JsonProperty(value = "used")
    private int used;

    /*
     * Resource quota limit.
     */
    @Generated
    @JsonProperty(value = "quota")
    private int quota;

    /*
     * Date/time when the resource quota usage will be reset.
     */
    @Generated
    @JsonProperty(value = "quotaResetDateTime")
    private OffsetDateTime quotaResetDateTime;

    /**
     * Creates an instance of QuotaDetails class.
     * 
     * @param used the used value to set.
     * @param quota the quota value to set.
     * @param quotaResetDateTime the quotaResetDateTime value to set.
     */
    @Generated
    @JsonCreator
    private QuotaDetails(@JsonProperty(value = "used") int used, @JsonProperty(value = "quota") int quota,
        @JsonProperty(value = "quotaResetDateTime") OffsetDateTime quotaResetDateTime) {
        this.used = used;
        this.quota = quota;
        this.quotaResetDateTime = quotaResetDateTime;
    }

    /**
     * Get the used property: Amount of the resource quota used.
     * 
     * @return the used value.
     */
    @Generated
    public int getUsed() {
        return this.used;
    }

    /**
     * Get the quota property: Resource quota limit.
     * 
     * @return the quota value.
     */
    @Generated
    public int getQuota() {
        return this.quota;
    }

    /**
     * Get the quotaResetDateTime property: Date/time when the resource quota usage will be reset.
     * 
     * @return the quotaResetDateTime value.
     */
    @Generated
    public OffsetDateTime getQuotaResetDateTime() {
        return this.quotaResetDateTime;
    }
}
