// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.time.OffsetDateTime;
import java.util.Map;

/**
 * Operation info.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "kind",
    defaultImpl = OperationDetails.class)
@JsonTypeName("OperationDetails")
@JsonSubTypes({
    @JsonSubTypes.Type(name = "documentModelCompose", value = DocumentModelComposeOperationDetails.class),
    @JsonSubTypes.Type(name = "documentModelCopyTo", value = DocumentModelCopyToOperationDetails.class),
    @JsonSubTypes.Type(name = "documentClassifierBuild", value = DocumentClassifierBuildOperationDetails.class),
    @JsonSubTypes.Type(name = "documentModelBuild", value = DocumentModelBuildOperationDetails.class) })
@Immutable
public class OperationDetails {
    /*
     * Operation ID
     */
    @Generated
    @JsonProperty(value = "operationId", access = JsonProperty.Access.WRITE_ONLY)
    private String operationId;

    /*
     * Operation status.
     */
    @Generated
    @JsonProperty(value = "status")
    private OperationStatus status;

    /*
     * Operation progress (0-100).
     */
    @Generated
    @JsonProperty(value = "percentCompleted")
    private Integer percentCompleted;

    /*
     * Date and time (UTC) when the operation was created.
     */
    @Generated
    @JsonProperty(value = "createdDateTime")
    private OffsetDateTime createdDateTime;

    /*
     * Date and time (UTC) when the status was last updated.
     */
    @Generated
    @JsonProperty(value = "lastUpdatedDateTime")
    private OffsetDateTime lastUpdatedDateTime;

    /*
     * URL of the resource targeted by this operation.
     */
    @Generated
    @JsonProperty(value = "resourceLocation")
    private String resourceLocation;

    /*
     * API version used to create this operation.
     */
    @Generated
    @JsonProperty(value = "apiVersion")
    private String apiVersion;

    /*
     * List of key-value tag attributes associated with the document model.
     */
    @Generated
    @JsonProperty(value = "tags")
    private Map<String, String> tags;

    /*
     * Encountered error.
     */
    @Generated
    @JsonProperty(value = "error")
    private Error error;

    /**
     * Creates an instance of OperationDetails class.
     * 
     * @param status the status value to set.
     * @param createdDateTime the createdDateTime value to set.
     * @param lastUpdatedDateTime the lastUpdatedDateTime value to set.
     * @param resourceLocation the resourceLocation value to set.
     */
    @Generated
    @JsonCreator
    protected OperationDetails(@JsonProperty(value = "status") OperationStatus status,
        @JsonProperty(value = "createdDateTime") OffsetDateTime createdDateTime,
        @JsonProperty(value = "lastUpdatedDateTime") OffsetDateTime lastUpdatedDateTime,
        @JsonProperty(value = "resourceLocation") String resourceLocation) {
        this.status = status;
        this.createdDateTime = createdDateTime;
        this.lastUpdatedDateTime = lastUpdatedDateTime;
        this.resourceLocation = resourceLocation;
    }

    /**
     * Get the operationId property: Operation ID.
     * 
     * @return the operationId value.
     */
    @Generated
    public String getOperationId() {
        return this.operationId;
    }

    /**
     * Get the status property: Operation status.
     * 
     * @return the status value.
     */
    @Generated
    public OperationStatus getStatus() {
        return this.status;
    }

    /**
     * Get the percentCompleted property: Operation progress (0-100).
     * 
     * @return the percentCompleted value.
     */
    @Generated
    public Integer getPercentCompleted() {
        return this.percentCompleted;
    }

    /**
     * Get the createdDateTime property: Date and time (UTC) when the operation was created.
     * 
     * @return the createdDateTime value.
     */
    @Generated
    public OffsetDateTime getCreatedDateTime() {
        return this.createdDateTime;
    }

    /**
     * Get the lastUpdatedDateTime property: Date and time (UTC) when the status was last updated.
     * 
     * @return the lastUpdatedDateTime value.
     */
    @Generated
    public OffsetDateTime getLastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    /**
     * Get the resourceLocation property: URL of the resource targeted by this operation.
     * 
     * @return the resourceLocation value.
     */
    @Generated
    public String getResourceLocation() {
        return this.resourceLocation;
    }

    /**
     * Get the apiVersion property: API version used to create this operation.
     * 
     * @return the apiVersion value.
     */
    @Generated
    public String getApiVersion() {
        return this.apiVersion;
    }

    /**
     * Get the tags property: List of key-value tag attributes associated with the document model.
     * 
     * @return the tags value.
     */
    @Generated
    public Map<String, String> getTags() {
        return this.tags;
    }

    /**
     * Get the error property: Encountered error.
     * 
     * @return the error value.
     */
    @Generated
    public Error getError() {
        return this.error;
    }
}
