// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * A word object consisting of a contiguous sequence of characters. For non-space
 * delimited languages, such as Chinese, Japanese, and Korean, each character is
 * represented as its own word.
 */
@Immutable
public final class DocumentWord {
    /*
     * Text content of the word.
     */
    @Generated
    @JsonProperty(value = "content")
    private String content;

    /*
     * Bounding polygon of the word, with coordinates specified relative to the
     * top-left of the page. The numbers represent the x, y values of the polygon
     * vertices, clockwise from the left (-180 degrees inclusive) relative to the
     * element orientation.
     */
    @Generated
    @JsonProperty(value = "polygon")
    private List<Double> polygon;

    /*
     * Location of the word in the reading order concatenated content.
     */
    @Generated
    @JsonProperty(value = "span")
    private DocumentSpan span;

    /*
     * Confidence of correctly extracting the word.
     */
    @Generated
    @JsonProperty(value = "confidence")
    private double confidence;

    /**
     * Creates an instance of DocumentWord class.
     * 
     * @param content the content value to set.
     * @param span the span value to set.
     * @param confidence the confidence value to set.
     */
    @Generated
    @JsonCreator
    private DocumentWord(@JsonProperty(value = "content") String content,
        @JsonProperty(value = "span") DocumentSpan span, @JsonProperty(value = "confidence") double confidence) {
        this.content = content;
        this.span = span;
        this.confidence = confidence;
    }

    /**
     * Get the content property: Text content of the word.
     * 
     * @return the content value.
     */
    @Generated
    public String getContent() {
        return this.content;
    }

    /**
     * Get the polygon property: Bounding polygon of the word, with coordinates specified relative to the
     * top-left of the page. The numbers represent the x, y values of the polygon
     * vertices, clockwise from the left (-180 degrees inclusive) relative to the
     * element orientation.
     * 
     * @return the polygon value.
     */
    @Generated
    public List<Double> getPolygon() {
        return this.polygon;
    }

    /**
     * Get the span property: Location of the word in the reading order concatenated content.
     * 
     * @return the span value.
     */
    @Generated
    public DocumentSpan getSpan() {
        return this.span;
    }

    /**
     * Get the confidence property: Confidence of correctly extracting the word.
     * 
     * @return the confidence value.
     */
    @Generated
    public double getConfidence() {
        return this.confidence;
    }
}
