// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/**
 * Document type info.
 */
@Immutable
public final class DocumentTypeDetails {
    /*
     * Document model description.
     */
    @Generated
    @JsonProperty(value = "description")
    private String description;

    /*
     * Custom document model build mode.
     */
    @Generated
    @JsonProperty(value = "buildMode")
    private DocumentBuildMode buildMode;

    /*
     * Description of the document semantic schema using a JSON Schema style syntax.
     */
    @Generated
    @JsonProperty(value = "fieldSchema")
    private Map<String, DocumentFieldSchema> fieldSchema;

    /*
     * Estimated confidence for each field.
     */
    @Generated
    @JsonProperty(value = "fieldConfidence")
    private Map<String, Double> fieldConfidence;

    /**
     * Creates an instance of DocumentTypeDetails class.
     * 
     * @param fieldSchema the fieldSchema value to set.
     */
    @Generated
    @JsonCreator
    private DocumentTypeDetails(@JsonProperty(value = "fieldSchema") Map<String, DocumentFieldSchema> fieldSchema) {
        this.fieldSchema = fieldSchema;
    }

    /**
     * Get the description property: Document model description.
     * 
     * @return the description value.
     */
    @Generated
    public String getDescription() {
        return this.description;
    }

    /**
     * Get the buildMode property: Custom document model build mode.
     * 
     * @return the buildMode value.
     */
    @Generated
    public DocumentBuildMode getBuildMode() {
        return this.buildMode;
    }

    /**
     * Get the fieldSchema property: Description of the document semantic schema using a JSON Schema style syntax.
     * 
     * @return the fieldSchema value.
     */
    @Generated
    public Map<String, DocumentFieldSchema> getFieldSchema() {
        return this.fieldSchema;
    }

    /**
     * Get the fieldConfidence property: Estimated confidence for each field.
     * 
     * @return the fieldConfidence value.
     */
    @Generated
    public Map<String, Double> getFieldConfidence() {
        return this.fieldConfidence;
    }
}
