// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Content and layout elements extracted from a page from the input.
 */
@Immutable
public final class DocumentPage {
    /*
     * 1-based page number in the input document.
     */
    @Generated
    @JsonProperty(value = "pageNumber")
    private int pageNumber;

    /*
     * The general orientation of the content in clockwise direction, measured in
     * degrees between (-180, 180].
     */
    @Generated
    @JsonProperty(value = "angle")
    private Double angle;

    /*
     * The width of the image/PDF in pixels/inches, respectively.
     */
    @Generated
    @JsonProperty(value = "width")
    private Double width;

    /*
     * The height of the image/PDF in pixels/inches, respectively.
     */
    @Generated
    @JsonProperty(value = "height")
    private Double height;

    /*
     * The unit used by the width, height, and polygon properties. For images, the
     * unit is "pixel". For PDF, the unit is "inch".
     */
    @Generated
    @JsonProperty(value = "unit")
    private LengthUnit unit;

    /*
     * Location of the page in the reading order concatenated content.
     */
    @Generated
    @JsonProperty(value = "spans")
    private List<DocumentSpan> spans;

    /*
     * Extracted words from the page.
     */
    @Generated
    @JsonProperty(value = "words")
    private List<DocumentWord> words;

    /*
     * Extracted selection marks from the page.
     */
    @Generated
    @JsonProperty(value = "selectionMarks")
    private List<DocumentSelectionMark> selectionMarks;

    /*
     * Extracted lines from the page, potentially containing both textual and visual
     * elements.
     */
    @Generated
    @JsonProperty(value = "lines")
    private List<DocumentLine> lines;

    /*
     * Extracted barcodes from the page.
     */
    @Generated
    @JsonProperty(value = "barcodes")
    private List<DocumentBarcode> barcodes;

    /*
     * Extracted formulas from the page.
     */
    @Generated
    @JsonProperty(value = "formulas")
    private List<DocumentFormula> formulas;

    /**
     * Creates an instance of DocumentPage class.
     * 
     * @param pageNumber the pageNumber value to set.
     * @param spans the spans value to set.
     */
    @Generated
    @JsonCreator
    private DocumentPage(@JsonProperty(value = "pageNumber") int pageNumber,
        @JsonProperty(value = "spans") List<DocumentSpan> spans) {
        this.pageNumber = pageNumber;
        this.spans = spans;
    }

    /**
     * Get the pageNumber property: 1-based page number in the input document.
     * 
     * @return the pageNumber value.
     */
    @Generated
    public int getPageNumber() {
        return this.pageNumber;
    }

    /**
     * Get the angle property: The general orientation of the content in clockwise direction, measured in
     * degrees between (-180, 180].
     * 
     * @return the angle value.
     */
    @Generated
    public Double getAngle() {
        return this.angle;
    }

    /**
     * Get the width property: The width of the image/PDF in pixels/inches, respectively.
     * 
     * @return the width value.
     */
    @Generated
    public Double getWidth() {
        return this.width;
    }

    /**
     * Get the height property: The height of the image/PDF in pixels/inches, respectively.
     * 
     * @return the height value.
     */
    @Generated
    public Double getHeight() {
        return this.height;
    }

    /**
     * Get the unit property: The unit used by the width, height, and polygon properties. For images, the
     * unit is "pixel". For PDF, the unit is "inch".
     * 
     * @return the unit value.
     */
    @Generated
    public LengthUnit getUnit() {
        return this.unit;
    }

    /**
     * Get the spans property: Location of the page in the reading order concatenated content.
     * 
     * @return the spans value.
     */
    @Generated
    public List<DocumentSpan> getSpans() {
        return this.spans;
    }

    /**
     * Get the words property: Extracted words from the page.
     * 
     * @return the words value.
     */
    @Generated
    public List<DocumentWord> getWords() {
        return this.words;
    }

    /**
     * Get the selectionMarks property: Extracted selection marks from the page.
     * 
     * @return the selectionMarks value.
     */
    @Generated
    public List<DocumentSelectionMark> getSelectionMarks() {
        return this.selectionMarks;
    }

    /**
     * Get the lines property: Extracted lines from the page, potentially containing both textual and visual
     * elements.
     * 
     * @return the lines value.
     */
    @Generated
    public List<DocumentLine> getLines() {
        return this.lines;
    }

    /**
     * Get the barcodes property: Extracted barcodes from the page.
     * 
     * @return the barcodes value.
     */
    @Generated
    public List<DocumentBarcode> getBarcodes() {
        return this.barcodes;
    }

    /**
     * Get the formulas property: Extracted formulas from the page.
     * 
     * @return the formulas value.
     */
    @Generated
    public List<DocumentFormula> getFormulas() {
        return this.formulas;
    }
}
