// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Document analysis result.
 */
@Immutable
public final class AnalyzeResult {
    /*
     * API version used to produce this result.
     */
    @Generated
    @JsonProperty(value = "apiVersion")
    private String apiVersion;

    /*
     * Document model ID used to produce this result.
     */
    @Generated
    @JsonProperty(value = "modelId")
    private String modelId;

    /*
     * Method used to compute string offset and length.
     */
    @Generated
    @JsonProperty(value = "stringIndexType")
    private StringIndexType stringIndexType;

    /*
     * Format of the analyze result top-level content.
     */
    @Generated
    @JsonProperty(value = "contentFormat")
    private ContentFormat contentFormat;

    /*
     * Concatenate string representation of all textual and visual elements in reading
     * order.
     */
    @Generated
    @JsonProperty(value = "content")
    private String content;

    /*
     * Analyzed pages.
     */
    @Generated
    @JsonProperty(value = "pages")
    private List<DocumentPage> pages;

    /*
     * Extracted paragraphs.
     */
    @Generated
    @JsonProperty(value = "paragraphs")
    private List<DocumentParagraph> paragraphs;

    /*
     * Extracted tables.
     */
    @Generated
    @JsonProperty(value = "tables")
    private List<DocumentTable> tables;

    /*
     * Extracted figures.
     */
    @Generated
    @JsonProperty(value = "figures")
    private List<DocumentFigure> figures;

    /*
     * Extracted lists.
     */
    @Generated
    @JsonProperty(value = "lists")
    private List<DocumentList> lists;

    /*
     * Extracted sections.
     */
    @Generated
    @JsonProperty(value = "sections")
    private List<DocumentSection> sections;

    /*
     * Extracted key-value pairs.
     */
    @Generated
    @JsonProperty(value = "keyValuePairs")
    private List<DocumentKeyValuePair> keyValuePairs;

    /*
     * Extracted font styles.
     */
    @Generated
    @JsonProperty(value = "styles")
    private List<DocumentStyle> styles;

    /*
     * Detected languages.
     */
    @Generated
    @JsonProperty(value = "languages")
    private List<DocumentLanguage> languages;

    /*
     * Extracted documents.
     */
    @Generated
    @JsonProperty(value = "documents")
    private List<Document> documents;

    /**
     * Creates an instance of AnalyzeResult class.
     * 
     * @param apiVersion the apiVersion value to set.
     * @param modelId the modelId value to set.
     * @param stringIndexType the stringIndexType value to set.
     * @param content the content value to set.
     * @param pages the pages value to set.
     */
    @Generated
    @JsonCreator
    private AnalyzeResult(@JsonProperty(value = "apiVersion") String apiVersion,
        @JsonProperty(value = "modelId") String modelId,
        @JsonProperty(value = "stringIndexType") StringIndexType stringIndexType,
        @JsonProperty(value = "content") String content, @JsonProperty(value = "pages") List<DocumentPage> pages) {
        this.apiVersion = apiVersion;
        this.modelId = modelId;
        this.stringIndexType = stringIndexType;
        this.content = content;
        this.pages = pages;
    }

    /**
     * Get the apiVersion property: API version used to produce this result.
     * 
     * @return the apiVersion value.
     */
    @Generated
    public String getApiVersion() {
        return this.apiVersion;
    }

    /**
     * Get the modelId property: Document model ID used to produce this result.
     * 
     * @return the modelId value.
     */
    @Generated
    public String getModelId() {
        return this.modelId;
    }

    /**
     * Get the stringIndexType property: Method used to compute string offset and length.
     * 
     * @return the stringIndexType value.
     */
    @Generated
    public StringIndexType getStringIndexType() {
        return this.stringIndexType;
    }

    /**
     * Get the contentFormat property: Format of the analyze result top-level content.
     * 
     * @return the contentFormat value.
     */
    @Generated
    public ContentFormat getContentFormat() {
        return this.contentFormat;
    }

    /**
     * Get the content property: Concatenate string representation of all textual and visual elements in reading
     * order.
     * 
     * @return the content value.
     */
    @Generated
    public String getContent() {
        return this.content;
    }

    /**
     * Get the pages property: Analyzed pages.
     * 
     * @return the pages value.
     */
    @Generated
    public List<DocumentPage> getPages() {
        return this.pages;
    }

    /**
     * Get the paragraphs property: Extracted paragraphs.
     * 
     * @return the paragraphs value.
     */
    @Generated
    public List<DocumentParagraph> getParagraphs() {
        return this.paragraphs;
    }

    /**
     * Get the tables property: Extracted tables.
     * 
     * @return the tables value.
     */
    @Generated
    public List<DocumentTable> getTables() {
        return this.tables;
    }

    /**
     * Get the figures property: Extracted figures.
     * 
     * @return the figures value.
     */
    @Generated
    public List<DocumentFigure> getFigures() {
        return this.figures;
    }

    /**
     * Get the lists property: Extracted lists.
     * 
     * @return the lists value.
     */
    @Generated
    public List<DocumentList> getLists() {
        return this.lists;
    }

    /**
     * Get the sections property: Extracted sections.
     * 
     * @return the sections value.
     */
    @Generated
    public List<DocumentSection> getSections() {
        return this.sections;
    }

    /**
     * Get the keyValuePairs property: Extracted key-value pairs.
     * 
     * @return the keyValuePairs value.
     */
    @Generated
    public List<DocumentKeyValuePair> getKeyValuePairs() {
        return this.keyValuePairs;
    }

    /**
     * Get the styles property: Extracted font styles.
     * 
     * @return the styles value.
     */
    @Generated
    public List<DocumentStyle> getStyles() {
        return this.styles;
    }

    /**
     * Get the languages property: Detected languages.
     * 
     * @return the languages value.
     */
    @Generated
    public List<DocumentLanguage> getLanguages() {
        return this.languages;
    }

    /**
     * Get the documents property: Extracted documents.
     * 
     * @return the documents value.
     */
    @Generated
    public List<Document> getDocuments() {
        return this.documents;
    }
}
