// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Address field value.
 */
@Immutable
public final class AddressValue {
    /*
     * House or building number.
     */
    @Generated
    @JsonProperty(value = "houseNumber")
    private String houseNumber;

    /*
     * Post office box number.
     */
    @Generated
    @JsonProperty(value = "poBox")
    private String poBox;

    /*
     * Street name.
     */
    @Generated
    @JsonProperty(value = "road")
    private String road;

    /*
     * Name of city, town, village, etc.
     */
    @Generated
    @JsonProperty(value = "city")
    private String city;

    /*
     * First-level administrative division.
     */
    @Generated
    @JsonProperty(value = "state")
    private String state;

    /*
     * Postal code used for mail sorting.
     */
    @Generated
    @JsonProperty(value = "postalCode")
    private String postalCode;

    /*
     * Country/region.
     */
    @Generated
    @JsonProperty(value = "countryRegion")
    private String countryRegion;

    /*
     * Street-level address, excluding city, state, countryRegion, and postalCode.
     */
    @Generated
    @JsonProperty(value = "streetAddress")
    private String streetAddress;

    /*
     * Apartment or office number
     */
    @Generated
    @JsonProperty(value = "unit")
    private String unit;

    /*
     * Districts or boroughs within a city, such as Brooklyn in New York City or City
     * of Westminster in London.
     */
    @Generated
    @JsonProperty(value = "cityDistrict")
    private String cityDistrict;

    /*
     * Second-level administrative division used in certain locales.
     */
    @Generated
    @JsonProperty(value = "stateDistrict")
    private String stateDistrict;

    /*
     * Unofficial neighborhood name, like Chinatown.
     */
    @Generated
    @JsonProperty(value = "suburb")
    private String suburb;

    /*
     * Build name, such as World Trade Center.
     */
    @Generated
    @JsonProperty(value = "house")
    private String house;

    /*
     * Floor number, such as 3F.
     */
    @Generated
    @JsonProperty(value = "level")
    private String level;

    /**
     * Creates an instance of AddressValue class.
     */
    @Generated
    private AddressValue() {
    }

    /**
     * Get the houseNumber property: House or building number.
     * 
     * @return the houseNumber value.
     */
    @Generated
    public String getHouseNumber() {
        return this.houseNumber;
    }

    /**
     * Get the poBox property: Post office box number.
     * 
     * @return the poBox value.
     */
    @Generated
    public String getPoBox() {
        return this.poBox;
    }

    /**
     * Get the road property: Street name.
     * 
     * @return the road value.
     */
    @Generated
    public String getRoad() {
        return this.road;
    }

    /**
     * Get the city property: Name of city, town, village, etc.
     * 
     * @return the city value.
     */
    @Generated
    public String getCity() {
        return this.city;
    }

    /**
     * Get the state property: First-level administrative division.
     * 
     * @return the state value.
     */
    @Generated
    public String getState() {
        return this.state;
    }

    /**
     * Get the postalCode property: Postal code used for mail sorting.
     * 
     * @return the postalCode value.
     */
    @Generated
    public String getPostalCode() {
        return this.postalCode;
    }

    /**
     * Get the countryRegion property: Country/region.
     * 
     * @return the countryRegion value.
     */
    @Generated
    public String getCountryRegion() {
        return this.countryRegion;
    }

    /**
     * Get the streetAddress property: Street-level address, excluding city, state, countryRegion, and postalCode.
     * 
     * @return the streetAddress value.
     */
    @Generated
    public String getStreetAddress() {
        return this.streetAddress;
    }

    /**
     * Get the unit property: Apartment or office number.
     * 
     * @return the unit value.
     */
    @Generated
    public String getUnit() {
        return this.unit;
    }

    /**
     * Get the cityDistrict property: Districts or boroughs within a city, such as Brooklyn in New York City or City
     * of Westminster in London.
     * 
     * @return the cityDistrict value.
     */
    @Generated
    public String getCityDistrict() {
        return this.cityDistrict;
    }

    /**
     * Get the stateDistrict property: Second-level administrative division used in certain locales.
     * 
     * @return the stateDistrict value.
     */
    @Generated
    public String getStateDistrict() {
        return this.stateDistrict;
    }

    /**
     * Get the suburb property: Unofficial neighborhood name, like Chinatown.
     * 
     * @return the suburb value.
     */
    @Generated
    public String getSuburb() {
        return this.suburb;
    }

    /**
     * Get the house property: Build name, such as World Trade Center.
     * 
     * @return the house value.
     */
    @Generated
    public String getHouse() {
        return this.house;
    }

    /**
     * Get the level property: Floor number, such as 3F.
     * 
     * @return the level value.
     */
    @Generated
    public String getLevel() {
        return this.level;
    }
}
