/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports;

import com.aventstack.extentreports.ExtentReports;
import com.aventstack.extentreports.ReactiveSubject;
import com.aventstack.extentreports.append.RawEntityConverter;
import com.aventstack.extentreports.model.Author;
import com.aventstack.extentreports.model.Category;
import com.aventstack.extentreports.model.Device;
import com.aventstack.extentreports.model.Log;
import com.aventstack.extentreports.model.Media;
import com.aventstack.extentreports.model.SystemEnvInfo;
import com.aventstack.extentreports.model.Test;
import com.aventstack.extentreports.model.service.MediaService;
import com.aventstack.extentreports.model.service.TestService;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;

public abstract class AbstractProcessor
extends ReactiveSubject {
    private String[] mediaResolverPath;
    private boolean usingNaturalConf = true;
    protected boolean keepLastRetryOnly;

    @Override
    protected void onTestCreated(Test test) {
        if (this.keepLastRetryOnly) {
            this.getReport().findTest(test.getName()).ifPresent(x -> this.getReport().removeTest((Test)x));
        }
        this.getReport().getTestList().add(test);
        super.onTestCreated(test);
    }

    @Override
    protected void onTestRemoved(Test test) {
        TestService.deleteTest(this.getReport().getTestList(), test);
        this.getReport().getAuthorCtx().removeTest(test);
        this.getReport().getCategoryCtx().removeTest(test);
        this.getReport().getDeviceCtx().removeTest(test);
        super.onTestRemoved(test);
    }

    protected void onNodeCreated(Test node) {
        if (this.keepLastRetryOnly) {
            this.getReport().findTest(node.getName()).ifPresent(x -> this.getReport().removeTest((Test)x));
        }
        super.onTestCreated(node);
    }

    @Override
    protected void onLogCreated(Log log, Test test) {
        super.onLogCreated(log, test);
        if (log.hasException()) {
            this.getReport().getExceptionInfoCtx().addContext(log.getException(), test);
        }
    }

    @Override
    protected void onMediaAdded(Media m, Test test) {
        this.tryResolvePath(m);
        super.onMediaAdded(m, test);
    }

    @Override
    protected void onMediaAdded(Media m, Log log, Test test) {
        this.tryResolvePath(m);
        super.onMediaAdded(m, log, test);
    }

    private void tryResolvePath(Media m) {
        MediaService.tryResolveMediaPath(m, this.mediaResolverPath);
    }

    protected void onAuthorAdded(Author x, Test test) {
        this.getReport().getAuthorCtx().addContext(x, test);
        super.onAuthorAssigned(x, test);
    }

    protected void onCategoryAdded(Category x, Test test) {
        this.getReport().getCategoryCtx().addContext(x, test);
        super.onCategoryAssigned(x, test);
    }

    protected void onDeviceAdded(Device x, Test test) {
        this.getReport().getDeviceCtx().addContext(x, test);
        super.onDeviceAssigned(x, test);
    }

    @Override
    protected void onFlush() {
        this.getReport().refresh();
        if (!this.usingNaturalConf) {
            this.getReport().applyOverrideConf();
        }
        super.onFlush();
    }

    protected void onReportLogAdded(String log) {
        this.getReport().getLogs().add(log);
    }

    protected void onSystemInfoAdded(SystemEnvInfo env) {
        this.getReport().getSystemEnvInfo().add(env);
    }

    protected void convertRawEntities(ExtentReports extent, File f) throws IOException {
        RawEntityConverter converter = new RawEntityConverter(extent);
        converter.convertAndApply(f);
    }

    @Generated
    public AbstractProcessor() {
    }

    @Generated
    public String[] getMediaResolverPath() {
        return this.mediaResolverPath;
    }

    @Generated
    public boolean isUsingNaturalConf() {
        return this.usingNaturalConf;
    }

    @Generated
    public boolean isKeepLastRetryOnly() {
        return this.keepLastRetryOnly;
    }

    @Generated
    public void setMediaResolverPath(String[] mediaResolverPath) {
        this.mediaResolverPath = mediaResolverPath;
    }

    @Generated
    public void setUsingNaturalConf(boolean usingNaturalConf) {
        this.usingNaturalConf = usingNaturalConf;
    }

    @Generated
    public void setKeepLastRetryOnly(boolean keepLastRetryOnly) {
        this.keepLastRetryOnly = keepLastRetryOnly;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractProcessor)) {
            return false;
        }
        AbstractProcessor other = (AbstractProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUsingNaturalConf() != other.isUsingNaturalConf()) {
            return false;
        }
        if (this.isKeepLastRetryOnly() != other.isKeepLastRetryOnly()) {
            return false;
        }
        return Arrays.deepEquals(this.getMediaResolverPath(), other.getMediaResolverPath());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractProcessor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUsingNaturalConf() ? 79 : 97);
        result = result * 59 + (this.isKeepLastRetryOnly() ? 79 : 97);
        result = result * 59 + Arrays.deepHashCode(this.getMediaResolverPath());
        return result;
    }

    @Generated
    public String toString() {
        return "AbstractProcessor(mediaResolverPath=" + Arrays.deepToString(this.getMediaResolverPath()) + ", usingNaturalConf=" + this.isUsingNaturalConf() + ", keepLastRetryOnly=" + this.isKeepLastRetryOnly() + ")";
    }
}

