/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.chaintest.storage;

import com.aventstack.chaintest.domain.Embed;
import com.aventstack.chaintest.domain.Test;
import com.aventstack.chaintest.storage.StorageService;
import com.azure.core.credential.TokenCredential;
import com.azure.identity.DefaultAzureCredential;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Base64;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureBlobClient
implements StorageService {
    private static final Logger log = LoggerFactory.getLogger(AzureBlobClient.class);
    private static final String AZURE_STORAGE_CONNECTION_STRING = "AZURE_STORAGE_CONNECTION_STRING";
    private static final String AZURE_CONTAINER_NAME = "AZURE_CONTAINER_NAME";
    private BlobContainerClient _containerClient;
    private String _prefix;

    @Override
    public boolean create(Map<String, String> config) {
        this._containerClient = this.getContainerClient(config);
        return null != this._containerClient;
    }

    private BlobServiceClient getServiceClient() {
        BlobServiceClientBuilder builder = new BlobServiceClientBuilder();
        String connectionString = System.getenv(AZURE_STORAGE_CONNECTION_STRING);
        if (connectionString == null) {
            connectionString = System.getProperty(AZURE_STORAGE_CONNECTION_STRING);
        }
        if (connectionString != null) {
            return builder.connectionString(connectionString).buildClient();
        }
        try {
            log.debug("Will use the DefaultAzureCredentialBuilder to authenticate");
            DefaultAzureCredential defaultAzureCredential = new DefaultAzureCredentialBuilder().build();
            return builder.credential((TokenCredential)defaultAzureCredential).buildClient();
        }
        catch (Exception e) {
            log.error("Failed to create Azure Blob Storage client", (Throwable)e);
            return null;
        }
    }

    private BlobContainerClient getContainerClient(Map<String, String> config) {
        BlobServiceClient serviceClient = this.getServiceClient();
        if (serviceClient == null) {
            return null;
        }
        String containerName = System.getenv(AZURE_CONTAINER_NAME);
        if (containerName == null) {
            containerName = System.getProperty(AZURE_CONTAINER_NAME);
        }
        if (containerName == null && config.containsKey("chaintest.storage.service.container-name")) {
            containerName = config.get("chaintest.storage.service.container-name");
        }
        containerName = containerName != null && !containerName.isBlank() ? containerName : "chaintest";
        serviceClient.createBlobContainerIfNotExists(containerName);
        return serviceClient.getBlobContainerClient(containerName);
    }

    @Override
    public void withPrefix(String prefix) {
        this._prefix = prefix;
    }

    @Override
    public void upload(Test test, String key, byte[] data) {
        String prefixKey = this.getPrefixKey(this._prefix, key);
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(data);){
            this._containerClient.getBlobClient(prefixKey).upload((InputStream)inputStream, (long)data.length);
            test.addScreenshotURL(this._containerClient.getBlobClient(key).getBlobUrl());
        }
        catch (Exception e) {
            log.error("Failed to upload key {} to Azure Blob Storage", (Object)key, (Object)e);
        }
    }

    @Override
    public void upload(Test test, String key, String base64) {
        byte[] data = Base64.getDecoder().decode(base64.getBytes());
        this.upload(test, key, data);
    }

    @Override
    public void upload(Test test, String key, File file) {
        String prefixKey = this.getPrefixKey(this._prefix, key);
        try {
            this._containerClient.getBlobClient(prefixKey).uploadFromFile(file.getAbsolutePath());
            test.addScreenshotURL(this._containerClient.getBlobClient(key + ".png").getBlobUrl());
        }
        catch (Exception e) {
            log.error("Failed to upload key {} to Azure Blob Storage", (Object)key, (Object)e);
        }
    }

    @Override
    public void upload(Test test, Embed embed) {
        if (null != embed.getBytes()) {
            this.upload(test, embed.getName(), embed.getBytes());
        } else if (null != embed.getBase64() && !embed.getBase64().isBlank()) {
            this.upload(test, embed.getName(), embed.getBase64());
        } else if (null != embed.getFile()) {
            this.upload(test, embed.getName(), embed.getFile());
        } else {
            log.error("Unable to upload Embed to Azure Blob Storage. Source missing");
        }
    }

    @Override
    public void close() {
    }
}

