/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.chaintest.generator;

import com.aventstack.chaintest.domain.Build;
import com.aventstack.chaintest.domain.Embed;
import com.aventstack.chaintest.domain.Test;
import com.aventstack.chaintest.generator.FileGenerator;
import com.aventstack.chaintest.generator.Generator;
import com.aventstack.chaintest.util.DateTimeUtil;
import com.aventstack.chaintest.util.IOUtil;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainTestSimpleGenerator
extends FileGenerator
implements Generator {
    private static final Logger log = LoggerFactory.getLogger(ChainTestSimpleGenerator.class);
    private static final String GENERATOR_NAME = "simple";
    private static final String BASE_PROPERTY = "chaintest.generator.simple";
    private static final String PROP_ENABLED = "chaintest.generator.simple.enabled";
    private static final String PROP_OUT_FILE_NAME = "chaintest.generator.simple.output-file";
    private static final String PROP_SAVE_OFFLINE = "chaintest.generator.simple.offline";
    private static final String PROP_DATETIME_FORMAT = "chaintest.generator.simple.datetime-format";
    private static final String PROP_DOCUMENT_TITLE = "chaintest.generator.simple.document-title";
    private static final String PROP_DARK_THEME = "chaintest.generator.simple.dark-theme";
    private static final String PROP_JS = "chaintest.generator.simple.js";
    private static final String PROP_CSS = "chaintest.generator.simple.css";
    private static final String BASE_TEMPLATE_NAME = "index.ftl";
    private static final String DEFAULT_OUT_FILE_NAME = "Simple.html";
    private static final String DEFAULT_OUT_DIR = "target/chaintest/";
    private static final String RESOURCES_DIR = "/resources";
    private static final String DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss a";
    private static final List<String> OFFLINE_RESOURCE_LIST = List.of("bootstrap.min.css", "bootstrap-icons.css", "bootstrap-icons.woff", "bootstrap-icons.woff2", "chart.umd.js", "template.css", "template.js");
    private static final Map<String, String> SHORTCUTS = Map.of("L", "Toggle theme (light/dark)", "f", "Toggle failed tests", "p", "Toggle passed tests", "s", "Toggle skipped tests", "esc", "Reset all filters");
    private boolean _started;
    private Build _build;
    private String _projectName;
    private File _outFile;
    private String _datetimeFormat;
    private String _documentTitle;
    private String _js;
    private String _css;
    private boolean _offline;
    private boolean _darkTheme = false;

    @Override
    public void start(Optional<Map<String, String>> config, String testRunner, Build build) {
        if (config.isEmpty()) {
            log.debug("Unable to load {} configuration, generator will now shutdown and no output will be produced", (Object)ChainTestSimpleGenerator.class.getSimpleName());
            return;
        }
        if (!Boolean.parseBoolean(config.get().get(PROP_ENABLED))) {
            log.debug("{} generator was not enabled. To enable, set property {}=true in your configuration", (Object)GENERATOR_NAME, (Object)PROP_ENABLED);
            return;
        }
        Object outputFileName = Optional.ofNullable(config.get().get(PROP_OUT_FILE_NAME)).filter(name -> !name.isEmpty()).orElse("target/chaintest/Simple.html");
        if (!((String)outputFileName).endsWith("htm") && !((String)outputFileName).endsWith("html")) {
            outputFileName = (String)outputFileName + "/Simple.html";
        }
        this._outFile = new File((String)outputFileName);
        this._offline = Boolean.parseBoolean(config.get().get(PROP_SAVE_OFFLINE));
        if (this._offline) {
            this.saveResources();
        }
        this._projectName = Optional.ofNullable(config.get().get("chaintest.project.name")).orElse("");
        this._datetimeFormat = Optional.ofNullable(config.get().get(PROP_DATETIME_FORMAT)).filter(DateTimeUtil::isPatternValid).orElse(DATETIME_FORMAT);
        this._documentTitle = Optional.ofNullable(config.get().get(PROP_DOCUMENT_TITLE)).orElse("chaintest");
        this._darkTheme = Boolean.parseBoolean(config.get().get(PROP_DARK_THEME));
        this._js = config.get().get(PROP_JS);
        this._css = config.get().get(PROP_CSS);
        this._build = build;
        log.trace("Start was called for testRunner: {}", (Object)testRunner);
        try {
            this.cacheTemplate(ChainTestSimpleGenerator.class, GENERATOR_NAME, BASE_TEMPLATE_NAME);
            this._started = true;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public boolean started() {
        return this._started;
    }

    private void saveResources() {
        File parentDir = this._outFile.getParentFile();
        new File(parentDir.getPath() + RESOURCES_DIR).mkdirs();
        for (String resource : OFFLINE_RESOURCE_LIST) {
            log.trace("Copying classpath resource {}", (Object)resource);
            IOUtil.copyClassPathResource(ChainTestSimpleGenerator.class, "simple/" + resource, parentDir.getPath() + "/resources/" + resource);
        }
    }

    @Override
    public void flush(Queue<Test> tests) {
        if (null == this._build || null == tests || tests.isEmpty() || this._build.getRunStats().isEmpty()) {
            log.debug("No tests to process, skipping flush");
            return;
        }
        File resourceDir = new File(this._outFile.getParentFile(), RESOURCES_DIR);
        resourceDir.mkdirs();
        this.saveEmbeds(tests, resourceDir);
        this.processTemplate(Map.of("build", this._build, "tests", tests, "shortcuts", SHORTCUTS, "config", Map.of("documentTitle", this._documentTitle, "projectName", this._projectName, "offline", this._offline, "datetimeFormat", this._datetimeFormat, "darkTheme", this._darkTheme, "js", this._js, "css", this._css)), this._outFile);
    }

    private void saveEmbeds(Queue<Test> tests, File resourceDir) {
        Test[] testsArray;
        for (Test test : testsArray = tests.toArray(new Test[0])) {
            for (Embed embed : test.getEmbeds()) {
                File toFile = embed.makePath(resourceDir);
                try {
                    embed.save(toFile);
                }
                catch (Exception e) {
                    log.error("Failed to save embed for test {} to resource dir {}", (Object)test.getName(), (Object)resourceDir.getPath());
                }
            }
            if (test.getChildren().isEmpty()) continue;
            this.saveEmbeds(test.getChildren(), resourceDir);
        }
    }

    @Override
    public void afterTest(Test test, Optional<Throwable> throwable) {
    }

    @Override
    public void executionFinished() {
    }

    @Override
    public String getName() {
        return GENERATOR_NAME;
    }
}

