/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.chaintest.generator;

import com.aventstack.chaintest.domain.Build;
import com.aventstack.chaintest.domain.Test;
import com.aventstack.chaintest.generator.FileGenerator;
import com.aventstack.chaintest.generator.Generator;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainTestEmailGenerator
extends FileGenerator
implements Generator {
    private static final Logger log = LoggerFactory.getLogger(ChainTestEmailGenerator.class);
    private static final String NAME = "email";
    private static final String EMAIL_CLIENT_ENABLED = "chaintest.generator.email.enabled";
    private static final String TEMPLATE_DIR = "email/";
    private static final String INDEX = "index.ftl";
    private static final String OUT_FILE = "target/chaintest/Email.html";
    private boolean _started;
    private Build _build;
    private String _source;

    public String getSource() {
        return this._source;
    }

    @Override
    public void start(Optional<Map<String, String>> config, String testRunner, Build build) {
        if (config.isEmpty()) {
            log.debug("Unable to load {} configuration, generator will now shutdown and no output will be produced", (Object)ChainTestEmailGenerator.class.getSimpleName());
            return;
        }
        String enabled = config.get().get(EMAIL_CLIENT_ENABLED);
        if (!Boolean.parseBoolean(enabled)) {
            log.debug("{} Generator was not enabled. To enable, set property {}=true in your configuration", (Object)NAME, (Object)EMAIL_CLIENT_ENABLED);
            return;
        }
        log.trace("Start was called for testRunner: {}", (Object)testRunner);
        this._build = build;
        try {
            this.cacheTemplate(ChainTestEmailGenerator.class, TEMPLATE_DIR, INDEX);
            this._started = true;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public boolean started() {
        return this._started;
    }

    @Override
    public void flush(Queue<Test> tests) {
        if (null == this._build || null == tests || tests.isEmpty() || this._build.getRunStats().isEmpty()) {
            log.debug("No tests to process, skipping flush");
            return;
        }
        this._source = this.processTemplate(Map.of("build", this._build, "tests", tests), OUT_FILE);
    }

    @Override
    public void afterTest(Test test, Optional<Throwable> throwable) {
    }

    @Override
    public void executionFinished() {
    }

    @Override
    public String getName() {
        return NAME;
    }
}

