/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.chaintest.domain;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Embed {
    private static final Logger log = LoggerFactory.getLogger(Embed.class);
    public static final List<String> SUPPORTED_MEDIA_TYPES = List.of("image/png", "image/jpg", "image/jpeg", "image/gif", "image/bmp", "image/webp", "image/tiff");
    private final UUID uuid = UUID.randomUUID();
    private String base64;
    private File file;
    private byte[] bytes;
    private String mediaType;

    public Embed(String base64, String mediaType) {
        this.base64 = base64;
        this.mediaType = mediaType;
    }

    public Embed(File file, String mediaType) {
        this.file = file;
        this.mediaType = mediaType;
    }

    public Embed(byte[] bytes, String mediaType) {
        this.bytes = bytes;
        this.mediaType = mediaType;
    }

    public void save(File filePath) throws IOException {
        if (!SUPPORTED_MEDIA_TYPES.contains(this.mediaType)) {
            log.debug("Unknown mediaType {}, skipping save", (Object)this.mediaType);
            return;
        }
        if (null != this.bytes) {
            Files.write(filePath.toPath(), this.bytes, new OpenOption[0]);
        } else if (null != this.base64 && !this.base64.isBlank()) {
            byte[] data = Base64.getDecoder().decode(this.base64.getBytes());
            Files.write(filePath.toPath(), data, new OpenOption[0]);
        } else if (null != this.file) {
            Files.copy(this.file.toPath(), filePath.toPath(), StandardCopyOption.REPLACE_EXISTING);
        } else {
            log.error("Unable to save Embed to {}. Source missing", (Object)filePath.getPath());
        }
    }

    public File makePath(File parentDir) {
        return new File(parentDir, this.getName());
    }

    public String getName() {
        String ext = this.mediaType.split("/")[1];
        return this.uuid + "." + ext;
    }

    public String id() {
        return this.uuid.toString();
    }

    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @Generated
    public String getBase64() {
        return this.base64;
    }

    @Generated
    public File getFile() {
        return this.file;
    }

    @Generated
    public byte[] getBytes() {
        return this.bytes;
    }

    @Generated
    public String getMediaType() {
        return this.mediaType;
    }

    @Generated
    public void setBase64(String base64) {
        this.base64 = base64;
    }

    @Generated
    public void setFile(File file) {
        this.file = file;
    }

    @Generated
    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    @Generated
    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Embed)) {
            return false;
        }
        Embed other = (Embed)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$uuid = this.getUuid();
        UUID other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
            return false;
        }
        String this$base64 = this.getBase64();
        String other$base64 = other.getBase64();
        if (this$base64 == null ? other$base64 != null : !this$base64.equals(other$base64)) {
            return false;
        }
        File this$file = this.getFile();
        File other$file = other.getFile();
        if (this$file == null ? other$file != null : !((Object)this$file).equals(other$file)) {
            return false;
        }
        if (!Arrays.equals(this.getBytes(), other.getBytes())) {
            return false;
        }
        String this$mediaType = this.getMediaType();
        String other$mediaType = other.getMediaType();
        return !(this$mediaType == null ? other$mediaType != null : !this$mediaType.equals(other$mediaType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Embed;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        String $base64 = this.getBase64();
        result = result * 59 + ($base64 == null ? 43 : $base64.hashCode());
        File $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
        result = result * 59 + Arrays.hashCode(this.getBytes());
        String $mediaType = this.getMediaType();
        result = result * 59 + ($mediaType == null ? 43 : $mediaType.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Embed(uuid=" + this.getUuid() + ", base64=" + this.getBase64() + ", file=" + this.getFile() + ", bytes=" + Arrays.toString(this.getBytes()) + ", mediaType=" + this.getMediaType() + ")";
    }

    @Generated
    public Embed() {
    }
}

