/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal.cash.grammar.kotlindsl.utils;

import com.autonomousapps.internal.antlr.v4.runtime.CommonTokenStream;
import com.autonomousapps.internal.antlr.v4.runtime.ParserRuleContext;
import com.autonomousapps.internal.antlr.v4.runtime.Token;
import com.autonomousapps.internal.squareup.cash.grammar.KotlinParser;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u000bJ\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u000bH\u0002J\f\u0010\u0016\u001a\u00020\u0015*\u00020\u000bH\u0002J\f\u0010\u0017\u001a\u00020\u0015*\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/autonomousapps/internal/cash/grammar/kotlindsl/utils/Comments;", "", "tokens", "Lcom/autonomousapps/internal/antlr/v4/runtime/CommonTokenStream;", "indent", "", "(Lorg/antlr/v4/runtime/CommonTokenStream;Ljava/lang/String;)V", "level", "", "getCommentsInBlock", "", "Lcom/autonomousapps/internal/antlr/v4/runtime/Token;", "ctx", "Lcom/autonomousapps/internal/squareup/cash/grammar/KotlinParser$NamedBlockContext;", "getCommentsToLeft", "before", "Lcom/autonomousapps/internal/antlr/v4/runtime/ParserRuleContext;", "onEnterBlock", "", "onExitBlock", "isComment", "", "isNotWhitespace", "isWhitespace", "core"})
public final class Comments {
    @NotNull
    private final CommonTokenStream tokens;
    @NotNull
    private final String indent;
    private int level;

    public Comments(@NotNull CommonTokenStream tokens, @NotNull String indent) {
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
        this.tokens = tokens;
        this.indent = indent;
    }

    public final void onEnterBlock() {
        int n = this.level;
        this.level = n + 1;
    }

    public final void onExitBlock() {
        int n = this.level;
        this.level = n + -1;
    }

    @Nullable
    public final String getCommentsToLeft(@NotNull ParserRuleContext before) {
        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
        Token token = before.start;
        Intrinsics.checkNotNullExpressionValue((Object)token, (String)"start");
        return this.getCommentsToLeft(token);
    }

    @Nullable
    public final String getCommentsToLeft(@NotNull Token before) {
        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
        int index = before.getTokenIndex() - 1;
        if (index <= 0) {
            return null;
        }
        Token next = this.tokens.get(index);
        while (next != null && this.isWhitespace(next)) {
            next = this.tokens.get(--index);
        }
        if (next == null) {
            return null;
        }
        ArrayDeque comments = new ArrayDeque();
        while (next != null) {
            if (this.isComment(next)) {
                String string = next.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                comments.addFirst((Object)string);
            } else if (this.isNotWhitespace(next)) break;
            next = this.tokens.get(--index);
        }
        if (comments.isEmpty()) {
            return null;
        }
        return CollectionsKt.joinToString$default((Iterable)((Iterable)comments), (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(this){
            final /* synthetic */ Comments this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return StringsKt.repeat((CharSequence)Comments.access$getIndent$p(this.this$0), (int)Comments.access$getLevel$p(this.this$0)) + it;
            }
        }), (int)30, null);
    }

    @NotNull
    public final List<Token> getCommentsInBlock(@NotNull KotlinParser.NamedBlockContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        List comments = new ArrayList();
        for (int index = ctx.start.getTokenIndex(); index <= ctx.stop.getTokenIndex(); ++index) {
            Token token = this.tokens.get(index);
            Intrinsics.checkNotNull((Object)token);
            if (!this.isComment(token)) continue;
            comments.add(token);
        }
        return comments;
    }

    private final boolean isWhitespace(Token $this$isWhitespace) {
        String string = $this$isWhitespace.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return StringsKt.isBlank((CharSequence)string);
    }

    private final boolean isNotWhitespace(Token $this$isNotWhitespace) {
        String string = $this$isNotWhitespace.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return !StringsKt.isBlank((CharSequence)string);
    }

    private final boolean isComment(Token $this$isComment) {
        return $this$isComment.getType() == 3 || $this$isComment.getType() == 2;
    }

    public static final /* synthetic */ String access$getIndent$p(Comments $this) {
        return $this.indent;
    }

    public static final /* synthetic */ int access$getLevel$p(Comments $this) {
        return $this.level;
    }
}

