/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal.antlr.v4.tool;

import com.autonomousapps.internal.antlr.runtime.RecognitionException;
import com.autonomousapps.internal.antlr.runtime.Token;
import com.autonomousapps.internal.antlr.v4.Tool;
import com.autonomousapps.internal.antlr.v4.tool.ANTLRMessage;
import com.autonomousapps.internal.antlr.v4.tool.ErrorSeverity;
import com.autonomousapps.internal.antlr.v4.tool.ErrorType;
import com.autonomousapps.internal.antlr.v4.tool.GrammarSemanticsMessage;
import com.autonomousapps.internal.antlr.v4.tool.GrammarSyntaxMessage;
import com.autonomousapps.internal.antlr.v4.tool.LeftRecursionCyclesMessage;
import com.autonomousapps.internal.antlr.v4.tool.Rule;
import com.autonomousapps.internal.antlr.v4.tool.ToolMessage;
import com.autonomousapps.internal.stringtemplate.v4.ST;
import com.autonomousapps.internal.stringtemplate.v4.STGroup;
import com.autonomousapps.internal.stringtemplate.v4.STGroupFile;
import com.autonomousapps.internal.stringtemplate.v4.misc.ErrorBuffer;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ErrorManager {
    private static final Map<String, STGroupFile> loadedFormats = new HashMap<String, STGroupFile>();
    public static final String FORMATS_DIR = "com/autonomousapps/internal/antlr/v4/tool/templates/messages/formats/";
    public Tool tool;
    public int errors;
    public int warnings;
    public Set<ErrorType> errorTypes = EnumSet.noneOf(ErrorType.class);
    STGroup format;
    String formatName;
    ErrorBuffer initSTListener = new ErrorBuffer();

    public ErrorManager(Tool tool) {
        this.tool = tool;
    }

    public void resetErrorState() {
        this.errors = 0;
        this.warnings = 0;
    }

    public ST getMessageTemplate(ANTLRMessage msg2) {
        ST messageST = msg2.getMessageTemplate(this.tool.longMessages);
        ST locationST = this.getLocationFormat();
        ST reportST = this.getReportFormat(msg2.getErrorType().severity);
        ST messageFormatST = this.getMessageFormat();
        boolean locationValid = false;
        if (msg2.line != -1) {
            locationST.add("line", msg2.line);
            locationValid = true;
        }
        if (msg2.charPosition != -1) {
            locationST.add("column", msg2.charPosition);
            locationValid = true;
        }
        if (msg2.fileName != null) {
            File f;
            String displayFileName = msg2.fileName;
            if (this.formatName.equals("antlr") && (f = new File(msg2.fileName)).exists()) {
                displayFileName = f.getName();
            }
            locationST.add("file", displayFileName);
            locationValid = true;
        }
        messageFormatST.add("id", msg2.getErrorType().code);
        messageFormatST.add("text", messageST);
        if (locationValid) {
            reportST.add("location", locationST);
        }
        reportST.add("message", messageFormatST);
        return reportST;
    }

    public ST getLocationFormat() {
        return this.format.getInstanceOf("location");
    }

    public ST getReportFormat(ErrorSeverity severity) {
        ST st = this.format.getInstanceOf("report");
        st.add("type", severity.getText());
        return st;
    }

    public ST getMessageFormat() {
        return this.format.getInstanceOf("message");
    }

    public boolean formatWantsSingleLineMessage() {
        return this.format.getInstanceOf("wantsSingleLineMessage").render().equals("true");
    }

    public void info(String msg2) {
        this.tool.info(msg2);
    }

    public void syntaxError(ErrorType etype, String fileName, Token token, RecognitionException antlrException, Object ... args) {
        GrammarSyntaxMessage msg2 = new GrammarSyntaxMessage(etype, fileName, token, antlrException, args);
        this.emit(etype, msg2);
    }

    public static void fatalInternalError(String error, Throwable e) {
        ErrorManager.internalError(error, e);
        throw new RuntimeException(error, e);
    }

    public static void internalError(String error, Throwable e) {
        StackTraceElement location = ErrorManager.getLastNonErrorManagerCodeLocation(e);
        ErrorManager.internalError("Exception " + e + "@" + location + ": " + error);
    }

    public static void internalError(String error) {
        StackTraceElement location = ErrorManager.getLastNonErrorManagerCodeLocation(new Exception());
        String msg2 = location + ": " + error;
        System.err.println("internal error: " + msg2);
    }

    public void toolError(ErrorType errorType, Object ... args) {
        this.toolError(errorType, null, args);
    }

    public void toolError(ErrorType errorType, Throwable e, Object ... args) {
        ToolMessage msg2 = new ToolMessage(errorType, e, args);
        this.emit(errorType, msg2);
    }

    public void grammarError(ErrorType etype, String fileName, Token token, Object ... args) {
        GrammarSemanticsMessage msg2 = new GrammarSemanticsMessage(etype, fileName, token, args);
        this.emit(etype, msg2);
    }

    public void leftRecursionCycles(String fileName, Collection<? extends Collection<Rule>> cycles) {
        ++this.errors;
        LeftRecursionCyclesMessage msg2 = new LeftRecursionCyclesMessage(fileName, cycles);
        this.tool.error(msg2);
    }

    public int getNumErrors() {
        return this.errors;
    }

    private static StackTraceElement getLastNonErrorManagerCodeLocation(Throwable e) {
        StackTraceElement t;
        int i;
        StackTraceElement[] stack = e.getStackTrace();
        for (i = 0; i < stack.length && (t = stack[i]).toString().contains("ErrorManager"); ++i) {
        }
        StackTraceElement location = stack[i];
        return location;
    }

    public void emit(ErrorType etype, ANTLRMessage msg2) {
        switch (etype.severity) {
            case WARNING_ONE_OFF: {
                if (this.errorTypes.contains((Object)etype)) break;
            }
            case WARNING: {
                ++this.warnings;
                this.tool.warning(msg2);
                break;
            }
            case ERROR_ONE_OFF: {
                if (this.errorTypes.contains((Object)etype)) break;
            }
            case ERROR: {
                ++this.errors;
                this.tool.error(msg2);
                break;
            }
        }
        this.errorTypes.add(etype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFormat(String formatName) {
        boolean formatOK;
        STGroupFile loadedFormat;
        Map<String, STGroupFile> map = loadedFormats;
        synchronized (map) {
            loadedFormat = loadedFormats.get(formatName);
            if (loadedFormat == null) {
                String fileName = FORMATS_DIR + formatName + STGroup.GROUP_FILE_EXTENSION;
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                URL url = cl.getResource(fileName);
                if (url == null) {
                    cl = ErrorManager.class.getClassLoader();
                    url = cl.getResource(fileName);
                }
                if (url == null && formatName.equals("antlr")) {
                    ErrorManager.rawError("ANTLR installation corrupted; cannot find ANTLR messages format file " + fileName);
                    ErrorManager.panic();
                } else if (url == null) {
                    ErrorManager.rawError("no such message format file " + fileName + " retrying with default ANTLR format");
                    this.setFormat("antlr");
                    return;
                }
                loadedFormat = new STGroupFile(url, "UTF-8", '<', '>');
                loadedFormat.load();
                loadedFormats.put(formatName, loadedFormat);
            }
        }
        this.formatName = formatName;
        this.format = loadedFormat;
        if (!this.initSTListener.errors.isEmpty()) {
            ErrorManager.rawError("ANTLR installation corrupted; can't load messages format file:\n" + this.initSTListener.toString());
            ErrorManager.panic();
        }
        if (!(formatOK = this.verifyFormat()) && formatName.equals("antlr")) {
            ErrorManager.rawError("ANTLR installation corrupted; ANTLR messages format file " + formatName + ".stg incomplete");
            ErrorManager.panic();
        } else if (!formatOK) {
            this.setFormat("antlr");
        }
    }

    protected boolean verifyFormat() {
        boolean ok = true;
        if (!this.format.isDefined("location")) {
            System.err.println("Format template 'location' not found in " + this.formatName);
            ok = false;
        }
        if (!this.format.isDefined("message")) {
            System.err.println("Format template 'message' not found in " + this.formatName);
            ok = false;
        }
        if (!this.format.isDefined("report")) {
            System.err.println("Format template 'report' not found in " + this.formatName);
            ok = false;
        }
        return ok;
    }

    static void rawError(String msg2) {
        System.err.println(msg2);
    }

    static void rawError(String msg2, Throwable e) {
        ErrorManager.rawError(msg2);
        e.printStackTrace(System.err);
    }

    public void panic(ErrorType errorType, Object ... args) {
        ToolMessage msg2 = new ToolMessage(errorType, args);
        ST msgST = this.getMessageTemplate(msg2);
        String outputMsg = msgST.render();
        if (this.formatWantsSingleLineMessage()) {
            outputMsg = outputMsg.replace('\n', ' ');
        }
        ErrorManager.panic(outputMsg);
    }

    public static void panic(String msg2) {
        ErrorManager.rawError(msg2);
        ErrorManager.panic();
    }

    public static void panic() {
        throw new Error("ANTLR ErrorManager panic");
    }
}

