/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.graph.Graphs;
import com.autonomousapps.internal.graph.GraphWriter;
import com.autonomousapps.internal.graph.GraphsKt;
import com.autonomousapps.internal.utils.GraphAdapter;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.Coordinates;
import com.autonomousapps.model.GradleVariantIdentification;
import com.autonomousapps.model.ProjectCoordinates;
import com.google.common.graph.Graph;
import com.google.common.graph.ImmutableGraph;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonWriter;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0007R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lcom/autonomousapps/tasks/GenerateWorkPlan;", "Lorg/gradle/api/DefaultTask;", "()V", "buildPath", "Lorg/gradle/api/provider/Property;", "", "getBuildPath", "()Lorg/gradle/api/provider/Property;", "combinedProjectGraphs", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getCombinedProjectGraphs", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "outputDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "action", "", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nGenerateWorkPlan.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateWorkPlan.kt\ncom/autonomousapps/tasks/GenerateWorkPlan\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 utils.kt\ncom/autonomousapps/internal/utils/UtilsKt\n+ 4 moshi.kt\ncom/autonomousapps/internal/utils/MoshiUtils\n*L\n1#1,76:1\n1557#2:77\n1628#2,2:78\n1630#2:88\n2669#2,7:89\n827#2:96\n855#2,2:97\n1863#2,2:99\n128#3,2:80\n41#4,2:82\n34#4,4:84\n191#4,3:101\n41#4,2:104\n34#4,4:106\n194#4,2:110\n*S KotlinDebug\n*F\n+ 1 GenerateWorkPlan.kt\ncom/autonomousapps/tasks/GenerateWorkPlan\n*L\n45#1:77\n45#1:78,2\n45#1:88\n46#1:89,7\n61#1:96\n61#1:97,2\n62#1:99,2\n45#1:80,2\n45#1:82,2\n45#1:84,4\n68#1:101,3\n68#1:104,2\n68#1:106,4\n68#1:110,2\n*E\n"})
public abstract class GenerateWorkPlan
extends DefaultTask {
    public GenerateWorkPlan() {
        this.setDescription("Generates work plan for fixing dependency issues with minimal conflict");
    }

    @Input
    @NotNull
    public abstract Property<String> getBuildPath();

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @NotNull
    public abstract ConfigurableFileCollection getCombinedProjectGraphs();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDirectory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @TaskAction
    public final void action() {
        String string;
        void $this$bufferWriteJson_u24default$iv;
        void $this$forEach$iv;
        Iterator $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        Graph acc;
        void $this$reduce$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Provider provider = this.getOutputDirectory().file("combined-graph.json");
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"outputDirectory.file(\"combined-graph.json\")");
        File combinedGraphOut = UtilsKt.getAndDelete((Provider<RegularFile>)provider);
        Provider provider2 = this.getOutputDirectory().file("combined-graph.gz");
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"outputDirectory.file(\"combined-graph.gz\")");
        File combinedGraphDotOut = UtilsKt.getAndDelete((Provider<RegularFile>)provider2);
        Provider provider3 = this.getOutputDirectory().file("work-plan.json");
        Intrinsics.checkNotNullExpressionValue((Object)provider3, (String)"outputDirectory.file(\"work-plan.json\")");
        File workPlanJsonOut = UtilsKt.getAndDelete((Provider<RegularFile>)provider3);
        Provider provider4 = this.getOutputDirectory().file("work-plan.txt");
        Intrinsics.checkNotNullExpressionValue((Object)provider4, (String)"outputDirectory.file(\"work-plan.txt\")");
        File workPlanTextOut = UtilsKt.getAndDelete((Provider<RegularFile>)provider4);
        Set set2 = this.getCombinedProjectGraphs().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"combinedProjectGraphs.files");
        Iterable iterable = set2;
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object object;
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            void $this$fromJson$iv = it;
            boolean $i$f$fromJson = false;
            Closeable closeable = (Closeable)UtilsKt.access$bufferRead((File)$this$fromJson$iv);
            Throwable throwable = null;
            try {
                JsonAdapter $this$withNulls$iv$iv$iv;
                BufferedSource reader$iv = (BufferedSource)closeable;
                boolean bl2 = false;
                boolean withNulls$iv$iv = false;
                boolean $i$f$getJsonAdapter = false;
                Intrinsics.checkNotNullExpressionValue((Object)MoshiUtils.getMOSHI().adapter(GraphAdapter.GraphContainer.class), (String)"MOSHI.adapter(T::class.java)");
                boolean $i$f$withNulls = false;
                Intrinsics.checkNotNull((Object)$this$withNulls$iv$iv$iv.fromJson(reader$iv));
            }
            catch (Throwable reader$iv) {
                throwable = reader$iv;
                throw reader$iv;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            collection.add(((GraphAdapter.GraphContainer)object).getGraph());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void graph;
            Graph $i$f$mapTo2 = (Graph)iterator$iv.next();
            acc = (Graph)accumulator$iv;
            boolean bl = false;
            accumulator$iv = GraphsKt.plus(acc, graph);
        }
        Graph combinedGraph = (Graph)accumulator$iv;
        Object object = this.getBuildPath().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"buildPath.get()");
        GraphWriter graphWriter = new GraphWriter((String)object);
        ProjectCoordinates rootProject = new ProjectCoordinates(":", GradleVariantIdentification.Companion.getEMPTY(), (String)this.getBuildPath().get());
        ImmutableGraph.Builder graphBuilder = GraphsKt.newGraphBuilder();
        accumulator$iv = Graphs.INSTANCE.roots(combinedGraph);
        boolean $i$f$filterNot = false;
        acc = $this$filterNot$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        Iterator bl = $this$filterNotTo$iv$iv.iterator();
        while (bl.hasNext()) {
            Object element$iv$iv = bl.next();
            Coordinates it = (Coordinates)element$iv$iv;
            boolean bl3 = false;
            if (Intrinsics.areEqual((Object)it.getIdentifier(), (Object)":")) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv2;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            Coordinates root = (Coordinates)element$iv;
            boolean bl4 = false;
            graphBuilder.putEdge((Object)new ProjectCoordinates(":", GradleVariantIdentification.Companion.getEMPTY(), null, 4, null), (Object)root);
        }
        ImmutableGraph immutableGraph = graphBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableGraph, (String)"graphBuilder.build()");
        Graph finalGraph = GraphsKt.plus((Graph)immutableGraph, combinedGraph);
        FilesKt.writeText$default((File)combinedGraphDotOut, (String)graphWriter.toDot(finalGraph), null, (int)2, null);
        File $i$f$forEach22 = combinedGraphOut;
        GraphAdapter.GraphContainer obj$iv = new GraphAdapter.GraphContainer(finalGraph);
        String indent$iv = "";
        boolean $i$f$bufferWriteJson = false;
        Closeable closeable = (Closeable)JsonWriter.of((BufferedSink)Okio.buffer((Sink)Okio.sink$default((File)$this$bufferWriteJson_u24default$iv, (boolean)false, (int)1, null)));
        Throwable throwable = null;
        try {
            JsonWriter writer$iv = (JsonWriter)closeable;
            boolean bl5 = false;
            boolean withNulls$iv$iv = false;
            boolean $i$f$getJsonAdapter = false;
            JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter(GraphAdapter.GraphContainer.class);
            Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"MOSHI.adapter(T::class.java)");
            JsonAdapter $this$withNulls$iv$iv$iv = jsonAdapter;
            boolean $i$f$withNulls = false;
            $this$withNulls$iv$iv$iv.indent(indent$iv).toJson(writer$iv, (Object)obj$iv);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        String it = string = graphWriter.workPlan(finalGraph);
        boolean bl6 = false;
        this.getLogger().quiet("[INCUBATING] Work plan:\n" + it);
    }
}

