/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal;

import com.autonomousapps.internal.ClassNameAndAnnotationsVisitor;
import com.autonomousapps.internal.JarExploder;
import com.autonomousapps.internal.asm.ClassReader;
import com.autonomousapps.internal.asm.ClassVisitor;
import com.autonomousapps.internal.utils.CollectionsKt;
import com.autonomousapps.model.internal.KtFile;
import com.autonomousapps.model.internal.PhysicalArtifact;
import com.autonomousapps.model.internal.intermediates.AndroidLinterDependency;
import com.autonomousapps.model.internal.intermediates.ExplodingJar;
import com.autonomousapps.model.internal.intermediates.producer.ExplodedJar;
import com.autonomousapps.services.InMemoryCache;
import com.autonomousapps.tasks.ExplodeJarTask;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0006J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u000eH\u0002J\u0018\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u0006*\b\u0012\u0004\u0012\u00020\u00040\u001cH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/autonomousapps/internal/JarExploder;", "", "artifacts", "", "Lcom/autonomousapps/model/internal/PhysicalArtifact;", "androidLinters", "", "Lcom/autonomousapps/model/internal/intermediates/AndroidLinterDependency;", "inMemoryCache", "Lcom/autonomousapps/services/InMemoryCache;", "(Ljava/util/List;Ljava/util/Set;Lcom/autonomousapps/services/InMemoryCache;)V", "logger", "Lorg/gradle/api/logging/Logger;", "explode", "Lcom/autonomousapps/model/internal/intermediates/ExplodingJar;", "artifact", "mode", "Lcom/autonomousapps/model/internal/PhysicalArtifact$Mode;", "explodedJars", "Lcom/autonomousapps/model/internal/intermediates/producer/ExplodedJar;", "findAndroidLinter", "", "physicalArtifact", "findInCache", "putInCache", "", "explodingJar", "toExplodedJars", "Lkotlin/sequences/Sequence;", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nJarExploder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JarExploder.kt\ncom/autonomousapps/internal/JarExploder\n+ 2 logging.kt\ncom/autonomousapps/internal/utils/LoggingKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n21#2:118\n1#3:119\n*S KotlinDebug\n*F\n+ 1 JarExploder.kt\ncom/autonomousapps/internal/JarExploder\n*L\n24#1:118\n*E\n"})
public final class JarExploder {
    @NotNull
    private final List<PhysicalArtifact> artifacts;
    @NotNull
    private final Set<AndroidLinterDependency> androidLinters;
    @NotNull
    private final InMemoryCache inMemoryCache;
    @NotNull
    private final Logger logger;

    public JarExploder(@NotNull List<PhysicalArtifact> artifacts, @NotNull Set<AndroidLinterDependency> androidLinters, @NotNull InMemoryCache inMemoryCache) {
        Intrinsics.checkNotNullParameter(artifacts, (String)"artifacts");
        Intrinsics.checkNotNullParameter(androidLinters, (String)"androidLinters");
        Intrinsics.checkNotNullParameter((Object)inMemoryCache, (String)"inMemoryCache");
        this.artifacts = artifacts;
        this.androidLinters = androidLinters;
        this.inMemoryCache = inMemoryCache;
        boolean $i$f$getLogger = false;
        Logger logger = Logging.getLogger(ExplodeJarTask.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(T::class.java)");
        this.logger = logger;
    }

    @NotNull
    public final Set<ExplodedJar> explodedJars() {
        return this.toExplodedJars((Sequence<PhysicalArtifact>)SequencesKt.filter((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)this.artifacts), (Function1)explodedJars.1.INSTANCE));
    }

    private final Set<ExplodedJar> toExplodedJars(Sequence<PhysicalArtifact> $this$toExplodedJars) {
        return SequencesKt.toSortedSet((Sequence)SequencesKt.map($this$toExplodedJars, (Function1)((Function1)new Function1<PhysicalArtifact, ExplodedJar>(this){
            final /* synthetic */ JarExploder this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final ExplodedJar invoke(PhysicalArtifact artifact) {
                Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
                ExplodingJar explodedJar = artifact.isJar() ? JarExploder.access$explode(this.this$0, artifact, PhysicalArtifact.Mode.ZIP) : JarExploder.access$explode(this.this$0, artifact, PhysicalArtifact.Mode.CLASSES);
                return new ExplodedJar(artifact, explodedJar);
            }
        })));
    }

    private final ExplodingJar explode(PhysicalArtifact artifact, PhysicalArtifact.Mode mode) {
        ExplodingJar explodingJar;
        Sequence sequence;
        ExplodingJar entry = this.findInCache(artifact);
        if (entry != null) {
            return entry;
        }
        Set<KtFile> ktFiles = null;
        switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
            case 1: {
                ZipFile zip = new ZipFile(artifact.getFile());
                ktFiles = KtFile.Companion.fromZip(zip);
                sequence = SequencesKt.map(CollectionsKt.asSequenceOfClassFiles(zip), (Function1)((Function1)new Function1<ZipEntry, ClassNameAndAnnotationsVisitor>(this, zip){
                    final /* synthetic */ JarExploder this$0;
                    final /* synthetic */ ZipFile $zip;
                    {
                        this.this$0 = $receiver;
                        this.$zip = $zip;
                        super(1);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final ClassNameAndAnnotationsVisitor invoke(ZipEntry classEntry) {
                        ClassReader classReader;
                        Intrinsics.checkNotNullParameter((Object)classEntry, (String)"classEntry");
                        ClassNameAndAnnotationsVisitor classNameAndAnnotationsVisitor = new ClassNameAndAnnotationsVisitor(JarExploder.access$getLogger$p(this.this$0));
                        ZipFile zipFile = this.$zip;
                        ClassNameAndAnnotationsVisitor $this$invoke_u24lambda_u241 = classNameAndAnnotationsVisitor;
                        boolean bl = false;
                        Closeable closeable = zipFile.getInputStream(classEntry);
                        Throwable throwable = null;
                        try {
                            InputStream it = (InputStream)closeable;
                            boolean bl2 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                            classReader = new ClassReader(ByteStreamsKt.readBytes((InputStream)it));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                        ClassReader reader = classReader;
                        reader.accept((ClassVisitor)$this$invoke_u24lambda_u241, 0);
                        return classNameAndAnnotationsVisitor;
                    }
                }));
                break;
            }
            case 2: {
                ktFiles = KtFile.Companion.fromDirectory(artifact.getFile());
                sequence = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walkBottomUp((File)artifact.getFile())), (Function1)explode.visitors.2.INSTANCE), (Function1)((Function1)new Function1<File, ClassNameAndAnnotationsVisitor>(this){
                    final /* synthetic */ JarExploder this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final ClassNameAndAnnotationsVisitor invoke(File classFile) {
                        ClassReader classReader;
                        ClassNameAndAnnotationsVisitor classNameAndAnnotationsVisitor;
                        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
                        ClassNameAndAnnotationsVisitor $this$invoke_u24lambda_u241 = classNameAndAnnotationsVisitor = new ClassNameAndAnnotationsVisitor(JarExploder.access$getLogger$p(this.this$0));
                        boolean bl = false;
                        Closeable closeable = new FileInputStream(classFile);
                        Throwable throwable = null;
                        try {
                            FileInputStream it = (FileInputStream)closeable;
                            boolean bl2 = false;
                            classReader = new ClassReader(ByteStreamsKt.readBytes((InputStream)it));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                        ClassReader reader = classReader;
                        reader.accept((ClassVisitor)$this$invoke_u24lambda_u241, 0);
                        return classNameAndAnnotationsVisitor;
                    }
                }));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Sequence visitors2 = sequence;
        SortedSet analyzedClasses2 = SequencesKt.toSortedSet((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.map((Sequence)visitors2, (Function1)explode.analyzedClasses.1.INSTANCE), (Function1)explode.analyzedClasses.2.INSTANCE));
        ExplodingJar it = explodingJar = new ExplodingJar(analyzedClasses2, ktFiles, this.findAndroidLinter(artifact));
        boolean bl = false;
        this.putInCache(artifact, it);
        return explodingJar;
    }

    private final ExplodingJar findInCache(PhysicalArtifact artifact) {
        String string = artifact.getFile().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"artifact.file.absolutePath");
        return this.inMemoryCache.explodedJar$dependency_analysis_gradle_plugin(string);
    }

    private final void putInCache(PhysicalArtifact artifact, ExplodingJar explodingJar) {
        String string = artifact.getFile().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"artifact.file.absolutePath");
        this.inMemoryCache.explodedJars$dependency_analysis_gradle_plugin(string, explodingJar);
    }

    private final String findAndroidLinter(PhysicalArtifact physicalArtifact) {
        Object v0;
        block1: {
            Iterable iterable = this.androidLinters;
            for (Object t : iterable) {
                AndroidLinterDependency it = (AndroidLinterDependency)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getCoordinates(), (Object)physicalArtifact.getCoordinates())) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        AndroidLinterDependency androidLinterDependency = v0;
        return androidLinterDependency != null ? androidLinterDependency.getLintRegistry() : null;
    }

    public static final /* synthetic */ ExplodingJar access$explode(JarExploder $this, PhysicalArtifact artifact, PhysicalArtifact.Mode mode) {
        return $this.explode(artifact, mode);
    }

    public static final /* synthetic */ Logger access$getLogger$p(JarExploder $this) {
        return $this.logger;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PhysicalArtifact.Mode.values().length];
            try {
                nArray[PhysicalArtifact.Mode.ZIP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhysicalArtifact.Mode.CLASSES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

