/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal;

import com.autonomousapps.internal.AsmKt;
import com.autonomousapps.internal.ClassRef;
import com.autonomousapps.internal.asm.AnnotationVisitor;
import com.autonomousapps.internal.asm.Type;
import com.autonomousapps.internal.utils.RegexKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u001a\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0016\u001a\u00020\fH\u0002J\b\u0010\u0010\u001a\u00020\u0003H\u0002J\u0016\u0010\u0017\u001a\u00020\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u0019H\u0002J\u001c\u0010\u001a\u001a\u00020\u00142\b\u0010\u001b\u001a\u0004\u0018\u00010\f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u001c\u0010\u001e\u001a\u00020\u00012\b\u0010\u001b\u001a\u0004\u0018\u00010\f2\b\u0010\u001f\u001a\u0004\u0018\u00010\fH\u0016J\u0012\u0010 \u001a\u00020\u00012\b\u0010\u001b\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010!\u001a\u00020\u0014H\u0016J&\u0010\"\u001a\u00020\u00142\b\u0010\u001b\u001a\u0004\u0018\u00010\f2\b\u0010\u001f\u001a\u0004\u0018\u00010\f2\b\u0010\u001c\u001a\u0004\u0018\u00010\fH\u0016R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/autonomousapps/internal/AnnotationAnalyzer;", "Lcom/autonomousapps/internal/asm/AnnotationVisitor;", "visible", "", "logger", "Lorg/gradle/api/logging/Logger;", "classes", "", "Lcom/autonomousapps/internal/ClassRef;", "level", "", "arrayName", "", "(ZLorg/gradle/api/logging/Logger;Ljava/util/Set;ILjava/lang/String;)V", "arrayElements", "arraySize", "isTypeAlias", "kind", "Lcom/autonomousapps/internal/ClassRef$Kind;", "addClass", "", "className", "indent", "log", "msgProvider", "Lkotlin/Function0;", "visit", "name", "value", "", "visitAnnotation", "descriptor", "visitArray", "visitEnd", "visitEnum", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nasm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 asm.kt\ncom/autonomousapps/internal/AnnotationAnalyzer\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,721:1\n1317#2,2:722\n1557#3:724\n1628#3,3:725\n*S KotlinDebug\n*F\n+ 1 asm.kt\ncom/autonomousapps/internal/AnnotationAnalyzer\n*L\n530#1:722,2\n558#1:724\n558#1:725,3\n*E\n"})
final class AnnotationAnalyzer
extends AnnotationVisitor {
    private final boolean visible;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Set<ClassRef> classes;
    private final int level;
    @Nullable
    private final String arrayName;
    private int arraySize;
    private boolean isTypeAlias;
    @NotNull
    private final Set<ClassRef> arrayElements;
    @NotNull
    private final ClassRef.Kind kind;

    public AnnotationAnalyzer(boolean visible, @NotNull Logger logger, @NotNull Set<ClassRef> classes2, int level, @Nullable String arrayName) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(classes2, (String)"classes");
        super(589824);
        this.visible = visible;
        this.logger = logger;
        this.classes = classes2;
        this.level = level;
        this.arrayName = arrayName;
        this.arrayElements = new LinkedHashSet();
        this.kind = this.visible ? ClassRef.Kind.NOT_ANNOTATION : ClassRef.Kind.ANNOTATION_VISIBLE;
    }

    public /* synthetic */ AnnotationAnalyzer(boolean bl, Logger logger, Set set2, int n, String string, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            n = 0;
        }
        if ((n2 & 0x10) != 0) {
            string = null;
        }
        this(bl, logger, set2, n, string);
    }

    private final void addClass(String className, ClassRef.Kind kind) {
        AsmKt.access$addClass(this.classes, className, kind);
        if (Intrinsics.areEqual((Object)this.arrayName, (Object)"d2")) {
            AsmKt.access$addClass(this.arrayElements, className, kind);
        }
    }

    private final void log(Function0<String> msgProvider) {
        if (!AsmKt.access$getLogDebug()) {
            this.logger.quiet((String)msgProvider.invoke());
        }
    }

    private final String indent() {
        return StringsKt.repeat((CharSequence)"  ", (int)this.level);
    }

    public void visit(@Nullable String name, @Nullable Object value) {
        String valueString = AsmKt.stringValueOfArrayElement(value);
        this.log((Function0<String>)((Function0)new Function0<String>(this, name, value, valueString){
            final /* synthetic */ AnnotationAnalyzer this$0;
            final /* synthetic */ String $name;
            final /* synthetic */ Object $value;
            final /* synthetic */ String $valueString;
            {
                this.this$0 = $receiver;
                this.$name = $name;
                this.$value = $value;
                this.$valueString = $valueString;
                super(0);
            }

            public final String invoke() {
                Class<?> clazz;
                return AnnotationAnalyzer.access$indent(this.this$0) + "- AnnotationAnalyzer#visit: name=" + this.$name + ", value=(" + ((clazz = this.$value) != null && (clazz = clazz.getClass()) != null ? clazz.getSimpleName() : null) + ", " + this.$valueString + ")";
            }
        }));
        if (this.arrayName != null) {
            int n = this.arraySize;
            this.arraySize = n + 1;
            if (Intrinsics.areEqual((Object)valueString, (Object)"alias")) {
                this.isTypeAlias = true;
            }
        }
        if (value instanceof String) {
            Sequence $this$forEach$iv = Regex.findAll$default((Regex)RegexKt.getMETHOD_DESCRIPTOR_REGEX(), (CharSequence)((CharSequence)value), (int)0, (int)2, null);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MatchResult result = (MatchResult)element$iv;
                boolean bl = false;
                this.addClass(result.getValue(), this.kind);
            }
        } else if (value instanceof Type) {
            this.addClass(((Type)value).getDescriptor(), this.kind);
        }
    }

    public void visitEnum(@Nullable String name, @Nullable String descriptor, @Nullable String value) {
        this.log((Function0<String>)((Function0)new Function0<String>(this, name, descriptor, value){
            final /* synthetic */ AnnotationAnalyzer this$0;
            final /* synthetic */ String $name;
            final /* synthetic */ String $descriptor;
            final /* synthetic */ String $value;
            {
                this.this$0 = $receiver;
                this.$name = $name;
                this.$descriptor = $descriptor;
                this.$value = $value;
                super(0);
            }

            public final String invoke() {
                return AnnotationAnalyzer.access$indent(this.this$0) + "- AnnotationAnalyzer#visitEnum: name=" + this.$name + ", descriptor=" + this.$descriptor + ", value=" + this.$value;
            }
        }));
        this.addClass(descriptor, this.kind);
    }

    @NotNull
    public AnnotationVisitor visitAnnotation(@Nullable String name, @Nullable String descriptor) {
        this.log((Function0<String>)((Function0)new Function0<String>(this, name, descriptor){
            final /* synthetic */ AnnotationAnalyzer this$0;
            final /* synthetic */ String $name;
            final /* synthetic */ String $descriptor;
            {
                this.this$0 = $receiver;
                this.$name = $name;
                this.$descriptor = $descriptor;
                super(0);
            }

            public final String invoke() {
                return AnnotationAnalyzer.access$indent(this.this$0) + "- AnnotationAnalyzer#visitAnnotation: name=" + this.$name + ", descriptor=" + this.$descriptor;
            }
        }));
        this.addClass(descriptor, this.kind);
        return new AnnotationAnalyzer(this.visible, this.logger, this.classes, this.level + 1, null, 16, null);
    }

    @NotNull
    public AnnotationVisitor visitArray(@Nullable String name) {
        this.log((Function0<String>)((Function0)new Function0<String>(this, name){
            final /* synthetic */ AnnotationAnalyzer this$0;
            final /* synthetic */ String $name;
            {
                this.this$0 = $receiver;
                this.$name = $name;
                super(0);
            }

            public final String invoke() {
                return AnnotationAnalyzer.access$indent(this.this$0) + "- AnnotationAnalyzer#visitArray: name=" + this.$name;
            }
        }));
        return new AnnotationAnalyzer(Intrinsics.areEqual((Object)name, (Object)"d2") ? false : this.visible, this.logger, this.classes, this.level + 1, name);
    }

    /*
     * WARNING - void declaration
     */
    public void visitEnd() {
        if (this.isTypeAlias()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = this.arrayElements;
            Set<ClassRef> set2 = this.classes;
            boolean $i$f$map = false;
            void var3_4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ClassRef classRef = (ClassRef)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new ClassRef(it.getClassRef(), ClassRef.Kind.NOT_ANNOTATION));
            }
            set2.addAll((List)destination$iv$iv);
        }
    }

    private final boolean isTypeAlias() {
        return this.arraySize == 3 && this.isTypeAlias;
    }

    public static final /* synthetic */ String access$indent(AnnotationAnalyzer $this) {
        return $this.indent();
    }
}

